/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.admins;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.admins.requests.ListActivityLogsRequest;
import com.intercom.api.resources.unstable.admins.requests.RetrieveAdminRequest;
import com.intercom.api.resources.unstable.admins.requests.SetAwayAdminRequest;
import com.intercom.api.resources.unstable.admins.types.Admin;
import com.intercom.api.resources.unstable.types.ActivityLogList;
import com.intercom.api.resources.unstable.types.AdminList;
import com.intercom.api.resources.unstable.types.AdminWithApp;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncAdminsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawAdminsClient rawClient;

    public AsyncAdminsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawAdminsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawAdminsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can view the currently authorised admin along with the embedded app object (a &quot;workspace&quot; in legacy terminology).
     * <blockquote>
     * <p>🚧 Single Sign On</p>
     * <p>If you are building a custom &quot;Log in with Intercom&quot; flow for your site, and you call the <code>/me</code> endpoint to identify the logged-in user, you should not accept any sign-ins from users with unverified email addresses as it poses a potential impersonation security risk.</p>
     * </blockquote>
     */
    public CompletableFuture<Optional<AdminWithApp>> identifyAdmin() {
        return this.rawClient.identifyAdmin().thenApply(response -> response.body());
    }

    /**
     * You can view the currently authorised admin along with the embedded app object (a &quot;workspace&quot; in legacy terminology).
     * <blockquote>
     * <p>🚧 Single Sign On</p>
     * <p>If you are building a custom &quot;Log in with Intercom&quot; flow for your site, and you call the <code>/me</code> endpoint to identify the logged-in user, you should not accept any sign-ins from users with unverified email addresses as it poses a potential impersonation security risk.</p>
     * </blockquote>
     */
    public CompletableFuture<Optional<AdminWithApp>> identifyAdmin(RequestOptions requestOptions) {
        return this.rawClient.identifyAdmin(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can set an Admin as away for the Inbox.
     */
    public CompletableFuture<Optional<Admin>> setAwayAdmin(SetAwayAdminRequest request) {
        return this.rawClient.setAwayAdmin(request).thenApply(response -> response.body());
    }

    /**
     * You can set an Admin as away for the Inbox.
     */
    public CompletableFuture<Optional<Admin>> setAwayAdmin(SetAwayAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.setAwayAdmin(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can get a log of activities by all admins in an app.
     */
    public CompletableFuture<ActivityLogList> listActivityLogs(ListActivityLogsRequest request) {
        return this.rawClient.listActivityLogs(request).thenApply(response -> response.body());
    }

    /**
     * You can get a log of activities by all admins in an app.
     */
    public CompletableFuture<ActivityLogList> listActivityLogs(
            ListActivityLogsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listActivityLogs(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of admins for a given workspace.
     */
    public CompletableFuture<AdminList> listAdmins() {
        return this.rawClient.listAdmins().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of admins for a given workspace.
     */
    public CompletableFuture<AdminList> listAdmins(RequestOptions requestOptions) {
        return this.rawClient.listAdmins(requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can retrieve the details of a single admin.
     */
    public CompletableFuture<Optional<Admin>> retrieveAdmin(RetrieveAdminRequest request) {
        return this.rawClient.retrieveAdmin(request).thenApply(response -> response.body());
    }

    /**
     * You can retrieve the details of a single admin.
     */
    public CompletableFuture<Optional<Admin>> retrieveAdmin(
            RetrieveAdminRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveAdmin(request, requestOptions).thenApply(response -> response.body());
    }
}
