/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.messages.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GetWhatsAppMessageStatusRequest.Builder.class)
public final class GetWhatsAppMessageStatusRequest {
    private final String rulesetId;

    private final Optional<Integer> perPage;

    private final Optional<String> startingAfter;

    private final Map<String, Object> additionalProperties;

    private GetWhatsAppMessageStatusRequest(
            String rulesetId,
            Optional<Integer> perPage,
            Optional<String> startingAfter,
            Map<String, Object> additionalProperties) {
        this.rulesetId = rulesetId;
        this.perPage = perPage;
        this.startingAfter = startingAfter;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the set of messages to check status for
     */
    @JsonProperty("ruleset_id")
    public String getRulesetId() {
        return rulesetId;
    }

    /**
     * @return Number of results per page (default 50, max 100)
     */
    @JsonProperty("per_page")
    public Optional<Integer> getPerPage() {
        return perPage;
    }

    /**
     * @return Cursor for pagination, used to fetch the next page of results
     */
    @JsonProperty("starting_after")
    public Optional<String> getStartingAfter() {
        return startingAfter;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GetWhatsAppMessageStatusRequest && equalTo((GetWhatsAppMessageStatusRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetWhatsAppMessageStatusRequest other) {
        return rulesetId.equals(other.rulesetId)
                && perPage.equals(other.perPage)
                && startingAfter.equals(other.startingAfter);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.rulesetId, this.perPage, this.startingAfter);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RulesetIdStage builder() {
        return new Builder();
    }

    public interface RulesetIdStage {
        /**
         * The unique identifier for the set of messages to check status for
         */
        _FinalStage rulesetId(@NotNull String rulesetId);

        Builder from(GetWhatsAppMessageStatusRequest other);
    }

    public interface _FinalStage {
        GetWhatsAppMessageStatusRequest build();

        /**
         * <p>Number of results per page (default 50, max 100)</p>
         */
        _FinalStage perPage(Optional<Integer> perPage);

        _FinalStage perPage(Integer perPage);

        /**
         * <p>Cursor for pagination, used to fetch the next page of results</p>
         */
        _FinalStage startingAfter(Optional<String> startingAfter);

        _FinalStage startingAfter(String startingAfter);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements RulesetIdStage, _FinalStage {
        private String rulesetId;

        private Optional<String> startingAfter = Optional.empty();

        private Optional<Integer> perPage = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(GetWhatsAppMessageStatusRequest other) {
            rulesetId(other.getRulesetId());
            perPage(other.getPerPage());
            startingAfter(other.getStartingAfter());
            return this;
        }

        /**
         * The unique identifier for the set of messages to check status for<p>The unique identifier for the set of messages to check status for</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ruleset_id")
        public _FinalStage rulesetId(@NotNull String rulesetId) {
            this.rulesetId = Objects.requireNonNull(rulesetId, "rulesetId must not be null");
            return this;
        }

        /**
         * <p>Cursor for pagination, used to fetch the next page of results</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage startingAfter(String startingAfter) {
            this.startingAfter = Optional.ofNullable(startingAfter);
            return this;
        }

        /**
         * <p>Cursor for pagination, used to fetch the next page of results</p>
         */
        @java.lang.Override
        @JsonSetter(value = "starting_after", nulls = Nulls.SKIP)
        public _FinalStage startingAfter(Optional<String> startingAfter) {
            this.startingAfter = startingAfter;
            return this;
        }

        /**
         * <p>Number of results per page (default 50, max 100)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        /**
         * <p>Number of results per page (default 50, max 100)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "per_page", nulls = Nulls.SKIP)
        public _FinalStage perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        @java.lang.Override
        public GetWhatsAppMessageStatusRequest build() {
            return new GetWhatsAppMessageStatusRequest(rulesetId, perPage, startingAfter, additionalProperties);
        }
    }
}
