/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickets;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.jobs.types.Jobs;
import com.intercom.api.resources.unstable.tickets.requests.DeleteTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.EnqueueCreateTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.GetTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.ReplyTicketRequest;
import com.intercom.api.resources.unstable.tickets.requests.UpdateTicketRequest;
import com.intercom.api.resources.unstable.tickets.types.DeleteTicketResponse;
import com.intercom.api.resources.unstable.tickets.types.Ticket;
import com.intercom.api.resources.unstable.types.SearchRequest;
import com.intercom.api.resources.unstable.types.TicketList;
import com.intercom.api.resources.unstable.types.TicketReply;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTicketsClient rawClient;

    public AsyncTicketsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTicketsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public CompletableFuture<TicketReply> replyTicket(ReplyTicketRequest request) {
        return this.rawClient.replyTicket(request).thenApply(response -> response.body());
    }

    /**
     * You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public CompletableFuture<TicketReply> replyTicket(ReplyTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.replyTicket(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * Enqueues ticket creation for asynchronous processing, returning if the job was enqueued successfully to be processed. We attempt to perform a best-effort validation on inputs before tasks are enqueued. If the given parameters are incorrect, we won't enqueue the job.
     */
    public CompletableFuture<Jobs> enqueueCreateTicket(EnqueueCreateTicketRequest request) {
        return this.rawClient.enqueueCreateTicket(request).thenApply(response -> response.body());
    }

    /**
     * Enqueues ticket creation for asynchronous processing, returning if the job was enqueued successfully to be processed. We attempt to perform a best-effort validation on inputs before tasks are enqueued. If the given parameters are incorrect, we won't enqueue the job.
     */
    public CompletableFuture<Jobs> enqueueCreateTicket(
            EnqueueCreateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.enqueueCreateTicket(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single ticket.
     */
    public CompletableFuture<Optional<Ticket>> getTicket(GetTicketRequest request) {
        return this.rawClient.getTicket(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single ticket.
     */
    public CompletableFuture<Optional<Ticket>> getTicket(GetTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.getTicket(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update a ticket.
     */
    public CompletableFuture<Optional<Ticket>> updateTicket(UpdateTicketRequest request) {
        return this.rawClient.updateTicket(request).thenApply(response -> response.body());
    }

    /**
     * You can update a ticket.
     */
    public CompletableFuture<Optional<Ticket>> updateTicket(
            UpdateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateTicket(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a ticket using the Intercom provided ID.
     */
    public CompletableFuture<DeleteTicketResponse> deleteTicket(DeleteTicketRequest request) {
        return this.rawClient.deleteTicket(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a ticket using the Intercom provided ID.
     */
    public CompletableFuture<DeleteTicketResponse> deleteTicket(
            DeleteTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteTicket(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for tickets, you send a <code>POST</code> request to <code>https://api.intercom.io/tickets/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiples there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foobar&quot;</code>).
     * The <code>source.body</code> field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a <code>&quot;I need support&quot;</code> body - the query should contain a <code>=</code> operator with the value <code>&quot;support&quot;</code> for such conversation to be returned. A query with a <code>=</code> operator and a <code>&quot;need support&quot;</code> value will not yield a result.</p>
     * <p>| Field                                     | Type                                                                                     |
     * | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                   |
     * | created_at                                | Date (UNIX timestamp)                                                                    |
     * | updated_at                                | Date (UNIX timestamp)                                                                    |
     * | <em>default_title</em>                           | String                                                                                   |
     * | <em>default_description</em>                     | String                                                                                   |
     * | category                                  | String                                                                                   |
     * | ticket_type_id                            | String                                                                                   |
     * | contact_ids                               | String                                                                                   |
     * | teammate_ids                              | String                                                                                   |
     * | admin_assignee_id                         | String                                                                                   |
     * | team_assignee_id                          | String                                                                                   |
     * | open                                      | Boolean                                                                                  |
     * | state                                     | String                                                                                   |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                    |
     * | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You may use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public CompletableFuture<TicketList> searchTickets(SearchRequest request) {
        return this.rawClient.searchTickets(request).thenApply(response -> response.body());
    }

    /**
     * You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for tickets, you send a <code>POST</code> request to <code>https://api.intercom.io/tickets/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiples there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foobar&quot;</code>).
     * The <code>source.body</code> field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a <code>&quot;I need support&quot;</code> body - the query should contain a <code>=</code> operator with the value <code>&quot;support&quot;</code> for such conversation to be returned. A query with a <code>=</code> operator and a <code>&quot;need support&quot;</code> value will not yield a result.</p>
     * <p>| Field                                     | Type                                                                                     |
     * | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                   |
     * | created_at                                | Date (UNIX timestamp)                                                                    |
     * | updated_at                                | Date (UNIX timestamp)                                                                    |
     * | <em>default_title</em>                           | String                                                                                   |
     * | <em>default_description</em>                     | String                                                                                   |
     * | category                                  | String                                                                                   |
     * | ticket_type_id                            | String                                                                                   |
     * | contact_ids                               | String                                                                                   |
     * | teammate_ids                              | String                                                                                   |
     * | admin_assignee_id                         | String                                                                                   |
     * | team_assignee_id                          | String                                                                                   |
     * | open                                      | Boolean                                                                                  |
     * | state                                     | String                                                                                   |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                    |
     * | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You may use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public CompletableFuture<TicketList> searchTickets(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchTickets(request, requestOptions).thenApply(response -> response.body());
    }
}
