/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationPartMetadata.Builder.class)
public final class ConversationPartMetadata {
    private final Optional<List<QuickReplyOptionsItem>> quickReplyOptions;

    private final Optional<String> quickReplyUuid;

    private final Map<String, Object> additionalProperties;

    private ConversationPartMetadata(
            Optional<List<QuickReplyOptionsItem>> quickReplyOptions,
            Optional<String> quickReplyUuid,
            Map<String, Object> additionalProperties) {
        this.quickReplyOptions = quickReplyOptions;
        this.quickReplyUuid = quickReplyUuid;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The quick reply options sent by the Admin or bot, presented in this conversation part.
     */
    @JsonProperty("quick_reply_options")
    public Optional<List<QuickReplyOptionsItem>> getQuickReplyOptions() {
        return quickReplyOptions;
    }

    /**
     * @return The unique identifier for the quick reply option that was clicked by the end user.
     */
    @JsonProperty("quick_reply_uuid")
    public Optional<String> getQuickReplyUuid() {
        return quickReplyUuid;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationPartMetadata && equalTo((ConversationPartMetadata) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPartMetadata other) {
        return quickReplyOptions.equals(other.quickReplyOptions) && quickReplyUuid.equals(other.quickReplyUuid);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.quickReplyOptions, this.quickReplyUuid);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<QuickReplyOptionsItem>> quickReplyOptions = Optional.empty();

        private Optional<String> quickReplyUuid = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ConversationPartMetadata other) {
            quickReplyOptions(other.getQuickReplyOptions());
            quickReplyUuid(other.getQuickReplyUuid());
            return this;
        }

        /**
         * <p>The quick reply options sent by the Admin or bot, presented in this conversation part.</p>
         */
        @JsonSetter(value = "quick_reply_options", nulls = Nulls.SKIP)
        public Builder quickReplyOptions(Optional<List<QuickReplyOptionsItem>> quickReplyOptions) {
            this.quickReplyOptions = quickReplyOptions;
            return this;
        }

        public Builder quickReplyOptions(List<QuickReplyOptionsItem> quickReplyOptions) {
            this.quickReplyOptions = Optional.ofNullable(quickReplyOptions);
            return this;
        }

        /**
         * <p>The unique identifier for the quick reply option that was clicked by the end user.</p>
         */
        @JsonSetter(value = "quick_reply_uuid", nulls = Nulls.SKIP)
        public Builder quickReplyUuid(Optional<String> quickReplyUuid) {
            this.quickReplyUuid = quickReplyUuid;
            return this;
        }

        public Builder quickReplyUuid(String quickReplyUuid) {
            this.quickReplyUuid = Optional.ofNullable(quickReplyUuid);
            return this;
        }

        public ConversationPartMetadata build() {
            return new ConversationPartMetadata(quickReplyOptions, quickReplyUuid, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = QuickReplyOptionsItem.Builder.class)
    public static final class QuickReplyOptionsItem implements IQuickReplyOption {
        private final String text;

        private final String uuid;

        private final Optional<Map<String, Object>> translations;

        private final Map<String, Object> additionalProperties;

        private QuickReplyOptionsItem(
                String text,
                String uuid,
                Optional<Map<String, Object>> translations,
                Map<String, Object> additionalProperties) {
            this.text = text;
            this.uuid = uuid;
            this.translations = translations;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The text to display in this quick reply option.
         */
        @JsonProperty("text")
        public String getText() {
            return text;
        }

        /**
         * @return A unique identifier for this quick reply option. This value will be available within the metadata of the comment conversation part that is created when a user clicks on this reply option.
         */
        @JsonProperty("uuid")
        public String getUuid() {
            return uuid;
        }

        /**
         * @return The translations for the quick reply option.
         */
        @JsonProperty("translations")
        public Optional<Map<String, Object>> getTranslations() {
            return translations;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof QuickReplyOptionsItem && equalTo((QuickReplyOptionsItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(QuickReplyOptionsItem other) {
            return text.equals(other.text) && uuid.equals(other.uuid) && translations.equals(other.translations);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.text, this.uuid, this.translations);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static TextStage builder() {
            return new Builder();
        }

        public interface TextStage {
            /**
             * The text to display in this quick reply option.
             */
            UuidStage text(@NotNull String text);

            Builder from(QuickReplyOptionsItem other);
        }

        public interface UuidStage {
            /**
             * A unique identifier for this quick reply option. This value will be available within the metadata of the comment conversation part that is created when a user clicks on this reply option.
             */
            _FinalStage uuid(@NotNull String uuid);
        }

        public interface _FinalStage {
            QuickReplyOptionsItem build();

            /**
             * <p>The translations for the quick reply option.</p>
             */
            _FinalStage translations(Optional<Map<String, Object>> translations);

            _FinalStage translations(Map<String, Object> translations);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements TextStage, UuidStage, _FinalStage {
            private String text;

            private String uuid;

            private Optional<Map<String, Object>> translations = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(QuickReplyOptionsItem other) {
                text(other.getText());
                uuid(other.getUuid());
                translations(other.getTranslations());
                return this;
            }

            /**
             * The text to display in this quick reply option.<p>The text to display in this quick reply option.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("text")
            public UuidStage text(@NotNull String text) {
                this.text = Objects.requireNonNull(text, "text must not be null");
                return this;
            }

            /**
             * A unique identifier for this quick reply option. This value will be available within the metadata of the comment conversation part that is created when a user clicks on this reply option.<p>A unique identifier for this quick reply option. This value will be available within the metadata of the comment conversation part that is created when a user clicks on this reply option.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("uuid")
            public _FinalStage uuid(@NotNull String uuid) {
                this.uuid = Objects.requireNonNull(uuid, "uuid must not be null");
                return this;
            }

            /**
             * <p>The translations for the quick reply option.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage translations(Map<String, Object> translations) {
                this.translations = Optional.ofNullable(translations);
                return this;
            }

            /**
             * <p>The translations for the quick reply option.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "translations", nulls = Nulls.SKIP)
            public _FinalStage translations(Optional<Map<String, Object>> translations) {
                this.translations = translations;
                return this;
            }

            @java.lang.Override
            public QuickReplyOptionsItem build() {
                return new QuickReplyOptionsItem(text, uuid, translations, additionalProperties);
            }
        }
    }
}
