/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LinkedObjectList.Builder.class)
public final class LinkedObjectList {
    private final Optional<String> type;

    private final Optional<Integer> totalCount;

    private final Optional<Boolean> hasMore;

    private final Optional<List<LinkedObject>> data;

    private final Map<String, Object> additionalProperties;

    private LinkedObjectList(
            Optional<String> type,
            Optional<Integer> totalCount,
            Optional<Boolean> hasMore,
            Optional<List<LinkedObject>> data,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.totalCount = totalCount;
        this.hasMore = hasMore;
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always list.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The total number of linked objects.
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    /**
     * @return Whether or not there are more linked objects than returned.
     */
    @JsonProperty("has_more")
    public Optional<Boolean> getHasMore() {
        return hasMore;
    }

    /**
     * @return An array containing the linked conversations and linked tickets.
     */
    @JsonProperty("data")
    public Optional<List<LinkedObject>> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LinkedObjectList && equalTo((LinkedObjectList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LinkedObjectList other) {
        return type.equals(other.type)
                && totalCount.equals(other.totalCount)
                && hasMore.equals(other.hasMore)
                && data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.totalCount, this.hasMore, this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<Boolean> hasMore = Optional.empty();

        private Optional<List<LinkedObject>> data = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(LinkedObjectList other) {
            type(other.getType());
            totalCount(other.getTotalCount());
            hasMore(other.getHasMore());
            data(other.getData());
            return this;
        }

        /**
         * <p>Always list.</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The total number of linked objects.</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        /**
         * <p>Whether or not there are more linked objects than returned.</p>
         */
        @JsonSetter(value = "has_more", nulls = Nulls.SKIP)
        public Builder hasMore(Optional<Boolean> hasMore) {
            this.hasMore = hasMore;
            return this;
        }

        public Builder hasMore(Boolean hasMore) {
            this.hasMore = Optional.ofNullable(hasMore);
            return this;
        }

        /**
         * <p>An array containing the linked conversations and linked tickets.</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(Optional<List<LinkedObject>> data) {
            this.data = data;
            return this;
        }

        public Builder data(List<LinkedObject> data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public LinkedObjectList build() {
            return new LinkedObjectList(type, totalCount, hasMore, data, additionalProperties);
        }
    }
}
