/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataTableItem.Builder.class)
public final class DataTableItem {
    private final String field;

    private final String value;

    private final Map<String, Object> additionalProperties;

    private DataTableItem(String field, String value, Map<String, Object> additionalProperties) {
        this.field = field;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of component you are rendering.
     */
    @JsonProperty("type")
    public String getType() {
        return "field-value";
    }

    /**
     * @return The text of the key in your key-value pair.
     */
    @JsonProperty("field")
    public String getField() {
        return field;
    }

    /**
     * @return The text of the value in your key-value pair.
     */
    @JsonProperty("value")
    public String getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataTableItem && equalTo((DataTableItem) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataTableItem other) {
        return field.equals(other.field) && value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.field, this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FieldStage builder() {
        return new Builder();
    }

    public interface FieldStage {
        /**
         * The text of the key in your key-value pair.
         */
        ValueStage field(@NotNull String field);

        Builder from(DataTableItem other);
    }

    public interface ValueStage {
        /**
         * The text of the value in your key-value pair.
         */
        _FinalStage value(@NotNull String value);
    }

    public interface _FinalStage {
        DataTableItem build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements FieldStage, ValueStage, _FinalStage {
        private String field;

        private String value;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DataTableItem other) {
            field(other.getField());
            value(other.getValue());
            return this;
        }

        /**
         * The text of the key in your key-value pair.<p>The text of the key in your key-value pair.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("field")
        public ValueStage field(@NotNull String field) {
            this.field = Objects.requireNonNull(field, "field must not be null");
            return this;
        }

        /**
         * The text of the value in your key-value pair.<p>The text of the value in your key-value pair.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("value")
        public _FinalStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @java.lang.Override
        public DataTableItem build() {
            return new DataTableItem(field, value, additionalProperties);
        }
    }
}
