/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListItem.Builder.class)
public final class ListItem implements IListItem {
    private final String id;

    private final String title;

    private final Optional<String> subtitle;

    private final Optional<String> tertiaryText;

    private final Optional<Boolean> roundedImage;

    private final Optional<Boolean> disabled;

    private final Optional<ActionComponent> action;

    private final Map<String, Object> additionalProperties;

    private ListItem(
            String id,
            String title,
            Optional<String> subtitle,
            Optional<String> tertiaryText,
            Optional<Boolean> roundedImage,
            Optional<Boolean> disabled,
            Optional<ActionComponent> action,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.title = title;
        this.subtitle = subtitle;
        this.tertiaryText = tertiaryText;
        this.roundedImage = roundedImage;
        this.disabled = disabled;
        this.action = action;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of component you are rendering.
     */
    @JsonProperty("type")
    public String getType() {
        return "item";
    }

    /**
     * @return A unique identifier for the item.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The text shown as the title for the item.
     */
    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    /**
     * @return The text shown underneath the item's title.
     */
    @JsonProperty("subtitle")
    public Optional<String> getSubtitle() {
        return subtitle;
    }

    /**
     * @return The text shown next to the subtitle, separates by a bullet.
     */
    @JsonProperty("tertiary_text")
    public Optional<String> getTertiaryText() {
        return tertiaryText;
    }

    /**
     * @return Rounds the corners of the image. Default is <code>false</code>.
     */
    @JsonProperty("rounded_image")
    public Optional<Boolean> getRoundedImage() {
        return roundedImage;
    }

    /**
     * @return Styles all list items and prevents the action. Default is <code>false</code>.
     */
    @JsonProperty("disabled")
    public Optional<Boolean> getDisabled() {
        return disabled;
    }

    /**
     * @return This can be a Submit Action, URL Action, or Sheets Action.
     */
    @JsonProperty("action")
    public Optional<ActionComponent> getAction() {
        return action;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListItem && equalTo((ListItem) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListItem other) {
        return id.equals(other.id)
                && title.equals(other.title)
                && subtitle.equals(other.subtitle)
                && tertiaryText.equals(other.tertiaryText)
                && roundedImage.equals(other.roundedImage)
                && disabled.equals(other.disabled)
                && action.equals(other.action);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id, this.title, this.subtitle, this.tertiaryText, this.roundedImage, this.disabled, this.action);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * A unique identifier for the item.
         */
        TitleStage id(@NotNull String id);

        Builder from(ListItem other);
    }

    public interface TitleStage {
        /**
         * The text shown as the title for the item.
         */
        _FinalStage title(@NotNull String title);
    }

    public interface _FinalStage {
        ListItem build();

        /**
         * <p>The text shown underneath the item's title.</p>
         */
        _FinalStage subtitle(Optional<String> subtitle);

        _FinalStage subtitle(String subtitle);

        /**
         * <p>The text shown next to the subtitle, separates by a bullet.</p>
         */
        _FinalStage tertiaryText(Optional<String> tertiaryText);

        _FinalStage tertiaryText(String tertiaryText);

        /**
         * <p>Rounds the corners of the image. Default is <code>false</code>.</p>
         */
        _FinalStage roundedImage(Optional<Boolean> roundedImage);

        _FinalStage roundedImage(Boolean roundedImage);

        /**
         * <p>Styles all list items and prevents the action. Default is <code>false</code>.</p>
         */
        _FinalStage disabled(Optional<Boolean> disabled);

        _FinalStage disabled(Boolean disabled);

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         */
        _FinalStage action(Optional<ActionComponent> action);

        _FinalStage action(ActionComponent action);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, TitleStage, _FinalStage {
        private String id;

        private String title;

        private Optional<ActionComponent> action = Optional.empty();

        private Optional<Boolean> disabled = Optional.empty();

        private Optional<Boolean> roundedImage = Optional.empty();

        private Optional<String> tertiaryText = Optional.empty();

        private Optional<String> subtitle = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ListItem other) {
            id(other.getId());
            title(other.getTitle());
            subtitle(other.getSubtitle());
            tertiaryText(other.getTertiaryText());
            roundedImage(other.getRoundedImage());
            disabled(other.getDisabled());
            action(other.getAction());
            return this;
        }

        /**
         * A unique identifier for the item.<p>A unique identifier for the item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public TitleStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The text shown as the title for the item.<p>The text shown as the title for the item.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("title")
        public _FinalStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage action(ActionComponent action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        /**
         * <p>This can be a Submit Action, URL Action, or Sheets Action.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "action", nulls = Nulls.SKIP)
        public _FinalStage action(Optional<ActionComponent> action) {
            this.action = action;
            return this;
        }

        /**
         * <p>Styles all list items and prevents the action. Default is <code>false</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        /**
         * <p>Styles all list items and prevents the action. Default is <code>false</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "disabled", nulls = Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        /**
         * <p>Rounds the corners of the image. Default is <code>false</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage roundedImage(Boolean roundedImage) {
            this.roundedImage = Optional.ofNullable(roundedImage);
            return this;
        }

        /**
         * <p>Rounds the corners of the image. Default is <code>false</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "rounded_image", nulls = Nulls.SKIP)
        public _FinalStage roundedImage(Optional<Boolean> roundedImage) {
            this.roundedImage = roundedImage;
            return this;
        }

        /**
         * <p>The text shown next to the subtitle, separates by a bullet.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage tertiaryText(String tertiaryText) {
            this.tertiaryText = Optional.ofNullable(tertiaryText);
            return this;
        }

        /**
         * <p>The text shown next to the subtitle, separates by a bullet.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "tertiary_text", nulls = Nulls.SKIP)
        public _FinalStage tertiaryText(Optional<String> tertiaryText) {
            this.tertiaryText = tertiaryText;
            return this;
        }

        /**
         * <p>The text shown underneath the item's title.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage subtitle(String subtitle) {
            this.subtitle = Optional.ofNullable(subtitle);
            return this;
        }

        /**
         * <p>The text shown underneath the item's title.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "subtitle", nulls = Nulls.SKIP)
        public _FinalStage subtitle(Optional<String> subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @java.lang.Override
        public ListItem build() {
            return new ListItem(
                    id, title, subtitle, tertiaryText, roundedImage, disabled, action, additionalProperties);
        }
    }
}
