/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SheetActionComponent.Builder.class)
public final class SheetActionComponent {
    private final String url;

    private final Map<String, Object> additionalProperties;

    private SheetActionComponent(String url, Map<String, Object> additionalProperties) {
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The link which hosts your sheet.
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SheetActionComponent && equalTo((SheetActionComponent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SheetActionComponent other) {
        return url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static UrlStage builder() {
        return new Builder();
    }

    public interface UrlStage {
        /**
         * The link which hosts your sheet.
         */
        _FinalStage url(@NotNull String url);

        Builder from(SheetActionComponent other);
    }

    public interface _FinalStage {
        SheetActionComponent build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements UrlStage, _FinalStage {
        private String url;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SheetActionComponent other) {
            url(other.getUrl());
            return this;
        }

        /**
         * The link which hosts your sheet.<p>The link which hosts your sheet.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @java.lang.Override
        public SheetActionComponent build() {
            return new SheetActionComponent(url, additionalProperties);
        }
    }
}
