/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SingleFilterSearchRequest.Builder.class)
public final class SingleFilterSearchRequest {
    private final Optional<String> field;

    private final Optional<Operator> operator;

    private final Optional<Value> value;

    private final Map<String, Object> additionalProperties;

    private SingleFilterSearchRequest(
            Optional<String> field,
            Optional<Operator> operator,
            Optional<Value> value,
            Map<String, Object> additionalProperties) {
        this.field = field;
        this.operator = operator;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The accepted field that you want to search on.
     */
    @JsonProperty("field")
    public Optional<String> getField() {
        return field;
    }

    /**
     * @return The accepted operators you can use to define how you want to search for the value.
     */
    @JsonProperty("operator")
    public Optional<Operator> getOperator() {
        return operator;
    }

    /**
     * @return The value that you want to search on.
     */
    @JsonProperty("value")
    public Optional<Value> getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SingleFilterSearchRequest && equalTo((SingleFilterSearchRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SingleFilterSearchRequest other) {
        return field.equals(other.field) && operator.equals(other.operator) && value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.field, this.operator, this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> field = Optional.empty();

        private Optional<Operator> operator = Optional.empty();

        private Optional<Value> value = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(SingleFilterSearchRequest other) {
            field(other.getField());
            operator(other.getOperator());
            value(other.getValue());
            return this;
        }

        /**
         * <p>The accepted field that you want to search on.</p>
         */
        @JsonSetter(value = "field", nulls = Nulls.SKIP)
        public Builder field(Optional<String> field) {
            this.field = field;
            return this;
        }

        public Builder field(String field) {
            this.field = Optional.ofNullable(field);
            return this;
        }

        /**
         * <p>The accepted operators you can use to define how you want to search for the value.</p>
         */
        @JsonSetter(value = "operator", nulls = Nulls.SKIP)
        public Builder operator(Optional<Operator> operator) {
            this.operator = operator;
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = Optional.ofNullable(operator);
            return this;
        }

        /**
         * <p>The value that you want to search on.</p>
         */
        @JsonSetter(value = "value", nulls = Nulls.SKIP)
        public Builder value(Optional<Value> value) {
            this.value = value;
            return this;
        }

        public Builder value(Value value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public SingleFilterSearchRequest build() {
            return new SingleFilterSearchRequest(field, operator, value, additionalProperties);
        }
    }

    public static final class Operator {
        public static final Operator GREATER_THAN = new Operator(Value.GREATER_THAN, ">");

        public static final Operator DOES_NOT_CONTAIN = new Operator(Value.DOES_NOT_CONTAIN, "!~");

        public static final Operator IN = new Operator(Value.IN, "IN");

        public static final Operator CONTAINS = new Operator(Value.CONTAINS, "~");

        public static final Operator LESS_THAN = new Operator(Value.LESS_THAN, "<");

        public static final Operator EQUALS = new Operator(Value.EQUALS, "=");

        public static final Operator NOT_EQUALS = new Operator(Value.NOT_EQUALS, "!=");

        public static final Operator ENDS_WITH = new Operator(Value.ENDS_WITH, "$");

        public static final Operator STARTS_WITH = new Operator(Value.STARTS_WITH, "^");

        public static final Operator NOT_IN = new Operator(Value.NOT_IN, "NIN");

        private final Value value;

        private final String string;

        Operator(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Operator && this.string.equals(((Operator) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case GREATER_THAN:
                    return visitor.visitGreaterThan();
                case DOES_NOT_CONTAIN:
                    return visitor.visitDoesNotContain();
                case IN:
                    return visitor.visitIn();
                case CONTAINS:
                    return visitor.visitContains();
                case LESS_THAN:
                    return visitor.visitLessThan();
                case EQUALS:
                    return visitor.visitEquals();
                case NOT_EQUALS:
                    return visitor.visitNotEquals();
                case ENDS_WITH:
                    return visitor.visitEndsWith();
                case STARTS_WITH:
                    return visitor.visitStartsWith();
                case NOT_IN:
                    return visitor.visitNotIn();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Operator valueOf(String value) {
            switch (value) {
                case ">":
                    return GREATER_THAN;
                case "!~":
                    return DOES_NOT_CONTAIN;
                case "IN":
                    return IN;
                case "~":
                    return CONTAINS;
                case "<":
                    return LESS_THAN;
                case "=":
                    return EQUALS;
                case "!=":
                    return NOT_EQUALS;
                case "$":
                    return ENDS_WITH;
                case "^":
                    return STARTS_WITH;
                case "NIN":
                    return NOT_IN;
                default:
                    return new Operator(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            EQUALS,

            NOT_EQUALS,

            IN,

            NOT_IN,

            LESS_THAN,

            GREATER_THAN,

            CONTAINS,

            DOES_NOT_CONTAIN,

            STARTS_WITH,

            ENDS_WITH,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitEquals();

            T visitNotEquals();

            T visitIn();

            T visitNotIn();

            T visitLessThan();

            T visitGreaterThan();

            T visitContains();

            T visitDoesNotContain();

            T visitStartsWith();

            T visitEndsWith();

            T visitUnknown(String unknownType);
        }
    }

    @JsonDeserialize(using = Value.Deserializer.class)
    public static final class Value {
        private final Object value;

        private final int type;

        private Value(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((String) this.value);
            } else if (this.type == 1) {
                return visitor.visit((int) this.value);
            } else if (this.type == 2) {
                return visitor.visitListOfString((List<String>) this.value);
            } else if (this.type == 3) {
                return visitor.visitListOfInteger((List<Integer>) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Value && equalTo((Value) other);
        }

        private boolean equalTo(Value other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static Value of(String value) {
            return new Value(value, 0);
        }

        public static Value of(int value) {
            return new Value(value, 1);
        }

        public static Value ofListOfString(List<String> value) {
            return new Value(value, 2);
        }

        public static Value ofListOfInteger(List<Integer> value) {
            return new Value(value, 3);
        }

        public interface Visitor<T> {
            T visit(String value);

            T visit(int value);

            T visitListOfString(List<String> value);

            T visitListOfInteger(List<Integer> value);
        }

        static final class Deserializer extends StdDeserializer<Value> {
            Deserializer() {
                super(Value.class);
            }

            @java.lang.Override
            public Value deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, String.class));
                } catch (IllegalArgumentException e) {
                }
                if (value instanceof Integer) {
                    return of((Integer) value);
                }
                try {
                    return ofListOfString(
                            ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<List<String>>() {}));
                } catch (IllegalArgumentException e) {
                }
                try {
                    return ofListOfInteger(
                            ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<List<Integer>>() {}));
                } catch (IllegalArgumentException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }
}
