/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.resources.conversations.types.Conversation;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SubmitRequest.Builder.class)
public final class SubmitRequest {
    private final String workspaceId;

    private final String workspaceRegion;

    private final Admin admin;

    private final String componentId;

    private final Context context;

    private final Conversation conversation;

    private final CurrentCanvas currentCanvas;

    private final Contact contact;

    private final Map<String, Object> inputValues;

    private final Contact user;

    private final Map<String, Object> additionalProperties;

    private SubmitRequest(
            String workspaceId,
            String workspaceRegion,
            Admin admin,
            String componentId,
            Context context,
            Conversation conversation,
            CurrentCanvas currentCanvas,
            Contact contact,
            Map<String, Object> inputValues,
            Contact user,
            Map<String, Object> additionalProperties) {
        this.workspaceId = workspaceId;
        this.workspaceRegion = workspaceRegion;
        this.admin = admin;
        this.componentId = componentId;
        this.context = context;
        this.conversation = conversation;
        this.currentCanvas = currentCanvas;
        this.contact = contact;
        this.inputValues = inputValues;
        this.user = user;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The workspace ID of the teammate. Attribute is <code>app_id</code> for V1.2 and below.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The Intercom hosted region that this app is located in.
     */
    @JsonProperty("workspace_region")
    public String getWorkspaceRegion() {
        return workspaceRegion;
    }

    /**
     * @return The Intercom teammate viewing the conversation.
     */
    @JsonProperty("admin")
    public Admin getAdmin() {
        return admin;
    }

    /**
     * @return The id of the component clicked by the teammate to trigger the request.
     */
    @JsonProperty("component_id")
    public String getComponentId() {
        return componentId;
    }

    /**
     * @return The context of where the app is added, where the user last visited, and information on the Messenger settings.
     */
    @JsonProperty("context")
    public Context getContext() {
        return context;
    }

    /**
     * @return The conversation where your app is being shown.
     */
    @JsonProperty("conversation")
    public Conversation getConversation() {
        return conversation;
    }

    /**
     * @return The current canvas the teammate can see.
     */
    @JsonProperty("current_canvas")
    public CurrentCanvas getCurrentCanvas() {
        return currentCanvas;
    }

    /**
     * @return The contact which is currently being viewed by the teammate in the conversation details panel.
     */
    @JsonProperty("contact")
    public Contact getContact() {
        return contact;
    }

    /**
     * @return A list of key/value pairs of data, inputted by the teammate on the current canvas.
     */
    @JsonProperty("input_values")
    public Map<String, Object> getInputValues() {
        return inputValues;
    }

    /**
     * @return The user who took the action.
     */
    @JsonProperty("user")
    public Contact getUser() {
        return user;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SubmitRequest && equalTo((SubmitRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubmitRequest other) {
        return workspaceId.equals(other.workspaceId)
                && workspaceRegion.equals(other.workspaceRegion)
                && admin.equals(other.admin)
                && componentId.equals(other.componentId)
                && context.equals(other.context)
                && conversation.equals(other.conversation)
                && currentCanvas.equals(other.currentCanvas)
                && contact.equals(other.contact)
                && inputValues.equals(other.inputValues)
                && user.equals(other.user);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.workspaceId,
                this.workspaceRegion,
                this.admin,
                this.componentId,
                this.context,
                this.conversation,
                this.currentCanvas,
                this.contact,
                this.inputValues,
                this.user);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WorkspaceIdStage builder() {
        return new Builder();
    }

    public interface WorkspaceIdStage {
        /**
         * The workspace ID of the teammate. Attribute is `app_id` for V1.2 and below.
         */
        WorkspaceRegionStage workspaceId(@NotNull String workspaceId);

        Builder from(SubmitRequest other);
    }

    public interface WorkspaceRegionStage {
        /**
         * The Intercom hosted region that this app is located in.
         */
        AdminStage workspaceRegion(@NotNull String workspaceRegion);
    }

    public interface AdminStage {
        /**
         * The Intercom teammate viewing the conversation.
         */
        ComponentIdStage admin(@NotNull Admin admin);
    }

    public interface ComponentIdStage {
        /**
         * The id of the component clicked by the teammate to trigger the request.
         */
        ContextStage componentId(@NotNull String componentId);
    }

    public interface ContextStage {
        /**
         * The context of where the app is added, where the user last visited, and information on the Messenger settings.
         */
        ConversationStage context(@NotNull Context context);
    }

    public interface ConversationStage {
        /**
         * The conversation where your app is being shown.
         */
        CurrentCanvasStage conversation(@NotNull Conversation conversation);
    }

    public interface CurrentCanvasStage {
        /**
         * The current canvas the teammate can see.
         */
        ContactStage currentCanvas(@NotNull CurrentCanvas currentCanvas);
    }

    public interface ContactStage {
        /**
         * The contact which is currently being viewed by the teammate in the conversation details panel.
         */
        UserStage contact(@NotNull Contact contact);
    }

    public interface UserStage {
        /**
         * The user who took the action.
         */
        _FinalStage user(@NotNull Contact user);
    }

    public interface _FinalStage {
        SubmitRequest build();

        /**
         * <p>A list of key/value pairs of data, inputted by the teammate on the current canvas.</p>
         */
        _FinalStage inputValues(Map<String, Object> inputValues);

        _FinalStage putAllInputValues(Map<String, Object> inputValues);

        _FinalStage inputValues(String key, Object value);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements WorkspaceIdStage,
                    WorkspaceRegionStage,
                    AdminStage,
                    ComponentIdStage,
                    ContextStage,
                    ConversationStage,
                    CurrentCanvasStage,
                    ContactStage,
                    UserStage,
                    _FinalStage {
        private String workspaceId;

        private String workspaceRegion;

        private Admin admin;

        private String componentId;

        private Context context;

        private Conversation conversation;

        private CurrentCanvas currentCanvas;

        private Contact contact;

        private Contact user;

        private Map<String, Object> inputValues = new LinkedHashMap<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SubmitRequest other) {
            workspaceId(other.getWorkspaceId());
            workspaceRegion(other.getWorkspaceRegion());
            admin(other.getAdmin());
            componentId(other.getComponentId());
            context(other.getContext());
            conversation(other.getConversation());
            currentCanvas(other.getCurrentCanvas());
            contact(other.getContact());
            inputValues(other.getInputValues());
            user(other.getUser());
            return this;
        }

        /**
         * The workspace ID of the teammate. Attribute is `app_id` for V1.2 and below.<p>The workspace ID of the teammate. Attribute is <code>app_id</code> for V1.2 and below.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public WorkspaceRegionStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        /**
         * The Intercom hosted region that this app is located in.<p>The Intercom hosted region that this app is located in.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_region")
        public AdminStage workspaceRegion(@NotNull String workspaceRegion) {
            this.workspaceRegion = Objects.requireNonNull(workspaceRegion, "workspaceRegion must not be null");
            return this;
        }

        /**
         * The Intercom teammate viewing the conversation.<p>The Intercom teammate viewing the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("admin")
        public ComponentIdStage admin(@NotNull Admin admin) {
            this.admin = Objects.requireNonNull(admin, "admin must not be null");
            return this;
        }

        /**
         * The id of the component clicked by the teammate to trigger the request.<p>The id of the component clicked by the teammate to trigger the request.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("component_id")
        public ContextStage componentId(@NotNull String componentId) {
            this.componentId = Objects.requireNonNull(componentId, "componentId must not be null");
            return this;
        }

        /**
         * The context of where the app is added, where the user last visited, and information on the Messenger settings.<p>The context of where the app is added, where the user last visited, and information on the Messenger settings.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("context")
        public ConversationStage context(@NotNull Context context) {
            this.context = Objects.requireNonNull(context, "context must not be null");
            return this;
        }

        /**
         * The conversation where your app is being shown.<p>The conversation where your app is being shown.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation")
        public CurrentCanvasStage conversation(@NotNull Conversation conversation) {
            this.conversation = Objects.requireNonNull(conversation, "conversation must not be null");
            return this;
        }

        /**
         * The current canvas the teammate can see.<p>The current canvas the teammate can see.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("current_canvas")
        public ContactStage currentCanvas(@NotNull CurrentCanvas currentCanvas) {
            this.currentCanvas = Objects.requireNonNull(currentCanvas, "currentCanvas must not be null");
            return this;
        }

        /**
         * The contact which is currently being viewed by the teammate in the conversation details panel.<p>The contact which is currently being viewed by the teammate in the conversation details panel.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("contact")
        public UserStage contact(@NotNull Contact contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        /**
         * The user who took the action.<p>The user who took the action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("user")
        public _FinalStage user(@NotNull Contact user) {
            this.user = Objects.requireNonNull(user, "user must not be null");
            return this;
        }

        /**
         * <p>A list of key/value pairs of data, inputted by the teammate on the current canvas.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage inputValues(String key, Object value) {
            this.inputValues.put(key, value);
            return this;
        }

        /**
         * <p>A list of key/value pairs of data, inputted by the teammate on the current canvas.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage putAllInputValues(Map<String, Object> inputValues) {
            this.inputValues.putAll(inputValues);
            return this;
        }

        /**
         * <p>A list of key/value pairs of data, inputted by the teammate on the current canvas.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "input_values", nulls = Nulls.SKIP)
        public _FinalStage inputValues(Map<String, Object> inputValues) {
            this.inputValues.clear();
            this.inputValues.putAll(inputValues);
            return this;
        }

        @java.lang.Override
        public SubmitRequest build() {
            return new SubmitRequest(
                    workspaceId,
                    workspaceRegion,
                    admin,
                    componentId,
                    context,
                    conversation,
                    currentCanvas,
                    contact,
                    inputValues,
                    user,
                    additionalProperties);
        }
    }
}
