/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SubmitResponse.Builder.class)
public final class SubmitResponse {
    private final CanvasObject canvas;

    private final Optional<Map<String, Object>> cardCreationOptions;

    private final Optional<Event> event;

    private final Map<String, Object> additionalProperties;

    private SubmitResponse(
            CanvasObject canvas,
            Optional<Map<String, Object>> cardCreationOptions,
            Optional<Event> event,
            Map<String, Object> additionalProperties) {
        this.canvas = canvas;
        this.cardCreationOptions = cardCreationOptions;
        this.event = event;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The canvas object that defines the new UI to be shown.
     */
    @JsonProperty("canvas")
    public CanvasObject getCanvas() {
        return canvas;
    }

    /**
     * @return Optional. Key-value pairs that will be sent in the initialize request to insert an app into the conversation reply.
     */
    @JsonProperty("card_creation_options")
    public Optional<Map<String, Object>> getCardCreationOptions() {
        return cardCreationOptions;
    }

    /**
     * @return Optional. Indicates if the app has completed its purpose.
     */
    @JsonProperty("event")
    public Optional<Event> getEvent() {
        return event;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SubmitResponse && equalTo((SubmitResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubmitResponse other) {
        return canvas.equals(other.canvas)
                && cardCreationOptions.equals(other.cardCreationOptions)
                && event.equals(other.event);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.canvas, this.cardCreationOptions, this.event);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CanvasStage builder() {
        return new Builder();
    }

    public interface CanvasStage {
        /**
         * The canvas object that defines the new UI to be shown.
         */
        _FinalStage canvas(@NotNull CanvasObject canvas);

        Builder from(SubmitResponse other);
    }

    public interface _FinalStage {
        SubmitResponse build();

        /**
         * <p>Optional. Key-value pairs that will be sent in the initialize request to insert an app into the conversation reply.</p>
         */
        _FinalStage cardCreationOptions(Optional<Map<String, Object>> cardCreationOptions);

        _FinalStage cardCreationOptions(Map<String, Object> cardCreationOptions);

        /**
         * <p>Optional. Indicates if the app has completed its purpose.</p>
         */
        _FinalStage event(Optional<Event> event);

        _FinalStage event(Event event);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CanvasStage, _FinalStage {
        private CanvasObject canvas;

        private Optional<Event> event = Optional.empty();

        private Optional<Map<String, Object>> cardCreationOptions = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SubmitResponse other) {
            canvas(other.getCanvas());
            cardCreationOptions(other.getCardCreationOptions());
            event(other.getEvent());
            return this;
        }

        /**
         * The canvas object that defines the new UI to be shown.<p>The canvas object that defines the new UI to be shown.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("canvas")
        public _FinalStage canvas(@NotNull CanvasObject canvas) {
            this.canvas = Objects.requireNonNull(canvas, "canvas must not be null");
            return this;
        }

        /**
         * <p>Optional. Indicates if the app has completed its purpose.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage event(Event event) {
            this.event = Optional.ofNullable(event);
            return this;
        }

        /**
         * <p>Optional. Indicates if the app has completed its purpose.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "event", nulls = Nulls.SKIP)
        public _FinalStage event(Optional<Event> event) {
            this.event = event;
            return this;
        }

        /**
         * <p>Optional. Key-value pairs that will be sent in the initialize request to insert an app into the conversation reply.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage cardCreationOptions(Map<String, Object> cardCreationOptions) {
            this.cardCreationOptions = Optional.ofNullable(cardCreationOptions);
            return this;
        }

        /**
         * <p>Optional. Key-value pairs that will be sent in the initialize request to insert an app into the conversation reply.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "card_creation_options", nulls = Nulls.SKIP)
        public _FinalStage cardCreationOptions(Optional<Map<String, Object>> cardCreationOptions) {
            this.cardCreationOptions = cardCreationOptions;
            return this;
        }

        @java.lang.Override
        public SubmitResponse build() {
            return new SubmitResponse(canvas, cardCreationOptions, event, additionalProperties);
        }
    }
}
