/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api;

import com.intercom.api.Intercom;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.Environment;
import okhttp3.OkHttpClient;

public final class IntercomBuilder {
    private ClientOptions.Builder clientOptionsBuilder = ClientOptions.builder();
    private String token = System.getenv("INTERCOM_API_KEY");
    private Environment environment = Environment.US_PRODUCTION;

    public IntercomBuilder token(String token) {
        this.token = token;
        return this;
    }

    public IntercomBuilder environment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public IntercomBuilder url(String url) {
        this.environment = Environment.custom(url);
        return this;
    }

    public IntercomBuilder timeout(int timeout) {
        this.clientOptionsBuilder.timeout(timeout);
        return this;
    }

    public IntercomBuilder maxRetries(int maxRetries) {
        this.clientOptionsBuilder.maxRetries(maxRetries);
        return this;
    }

    public IntercomBuilder httpClient(OkHttpClient httpClient) {
        this.clientOptionsBuilder.httpClient(httpClient);
        return this;
    }

    public Intercom build() {
        if (this.token == null) {
            throw new RuntimeException("Please provide token or set the INTERCOM_API_KEY environment variable.");
        }
        this.clientOptionsBuilder.addHeader("Authorization", "Bearer " + this.token);
        this.clientOptionsBuilder.environment(this.environment);
        return new Intercom(this.clientOptionsBuilder.build());
    }
}

