/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.articles.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ArticleTranslatedContent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateArticleRequest {
    private final String articleId;
    private final Optional<String> title;
    private final Optional<String> description;
    private final Optional<String> body;
    private final Optional<Integer> authorId;
    private final Optional<State> state;
    private final Optional<String> parentId;
    private final Optional<ParentType> parentType;
    private final Optional<ArticleTranslatedContent> translatedContent;
    private final Map<String, Object> additionalProperties;

    private UpdateArticleRequest(String articleId, Optional<String> title, Optional<String> description, Optional<String> body, Optional<Integer> authorId, Optional<State> state, Optional<String> parentId, Optional<ParentType> parentType, Optional<ArticleTranslatedContent> translatedContent, Map<String, Object> additionalProperties) {
        this.articleId = articleId;
        this.title = title;
        this.description = description;
        this.body = body;
        this.authorId = authorId;
        this.state = state;
        this.parentId = parentId;
        this.parentType = parentType;
        this.translatedContent = translatedContent;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="article_id")
    public String getArticleId() {
        return this.articleId;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="author_id")
    public Optional<Integer> getAuthorId() {
        return this.authorId;
    }

    @JsonProperty(value="state")
    public Optional<State> getState() {
        return this.state;
    }

    @JsonProperty(value="parent_id")
    public Optional<String> getParentId() {
        return this.parentId;
    }

    @JsonProperty(value="parent_type")
    public Optional<ParentType> getParentType() {
        return this.parentType;
    }

    @JsonProperty(value="translated_content")
    public Optional<ArticleTranslatedContent> getTranslatedContent() {
        return this.translatedContent;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateArticleRequest && this.equalTo((UpdateArticleRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateArticleRequest other) {
        return this.articleId.equals(other.articleId) && this.title.equals(other.title) && this.description.equals(other.description) && this.body.equals(other.body) && this.authorId.equals(other.authorId) && this.state.equals(other.state) && this.parentId.equals(other.parentId) && this.parentType.equals(other.parentType) && this.translatedContent.equals(other.translatedContent);
    }

    public int hashCode() {
        return Objects.hash(this.articleId, this.title, this.description, this.body, this.authorId, this.state, this.parentId, this.parentType, this.translatedContent);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ArticleIdStage builder() {
        return new Builder();
    }

    public static final class State {
        public static final State PUBLISHED = new State(Value.PUBLISHED, "published");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case PUBLISHED: {
                    return visitor.visitPublished();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "published": {
                    return PUBLISHED;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPublished();

            public T visitDraft();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PUBLISHED,
            DRAFT,
            UNKNOWN;

        }
    }

    public static final class ParentType {
        public static final ParentType SECTION = new ParentType(Value.SECTION, "section");
        public static final ParentType COLLECTION = new ParentType(Value.COLLECTION, "collection");
        private final Value value;
        private final String string;

        ParentType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ParentType && this.string.equals(((ParentType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SECTION: {
                    return visitor.visitSection();
                }
                case COLLECTION: {
                    return visitor.visitCollection();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static ParentType valueOf(String value) {
            switch (value) {
                case "section": {
                    return SECTION;
                }
                case "collection": {
                    return COLLECTION;
                }
            }
            return new ParentType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitCollection();

            public T visitSection();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            COLLECTION,
            SECTION,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ArticleIdStage,
    _FinalStage {
        private String articleId;
        private Optional<ArticleTranslatedContent> translatedContent = Optional.empty();
        private Optional<ParentType> parentType = Optional.empty();
        private Optional<String> parentId = Optional.empty();
        private Optional<State> state = Optional.empty();
        private Optional<Integer> authorId = Optional.empty();
        private Optional<String> body = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> title = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateArticleRequest other) {
            this.articleId(other.getArticleId());
            this.title(other.getTitle());
            this.description(other.getDescription());
            this.body(other.getBody());
            this.authorId(other.getAuthorId());
            this.state(other.getState());
            this.parentId(other.getParentId());
            this.parentType(other.getParentType());
            this.translatedContent(other.getTranslatedContent());
            return this;
        }

        @Override
        @JsonSetter(value="article_id")
        public _FinalStage articleId(@NotNull String articleId) {
            this.articleId = Objects.requireNonNull(articleId, "articleId must not be null");
            return this;
        }

        @Override
        public _FinalStage translatedContent(ArticleTranslatedContent translatedContent) {
            this.translatedContent = Optional.ofNullable(translatedContent);
            return this;
        }

        @Override
        @JsonSetter(value="translated_content", nulls=Nulls.SKIP)
        public _FinalStage translatedContent(Optional<ArticleTranslatedContent> translatedContent) {
            this.translatedContent = translatedContent;
            return this;
        }

        @Override
        public _FinalStage parentType(ParentType parentType) {
            this.parentType = Optional.ofNullable(parentType);
            return this;
        }

        @Override
        @JsonSetter(value="parent_type", nulls=Nulls.SKIP)
        public _FinalStage parentType(Optional<ParentType> parentType) {
            this.parentType = parentType;
            return this;
        }

        @Override
        public _FinalStage parentId(String parentId) {
            this.parentId = Optional.ofNullable(parentId);
            return this;
        }

        @Override
        @JsonSetter(value="parent_id", nulls=Nulls.SKIP)
        public _FinalStage parentId(Optional<String> parentId) {
            this.parentId = parentId;
            return this;
        }

        @Override
        public _FinalStage state(State state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @Override
        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public _FinalStage state(Optional<State> state) {
            this.state = state;
            return this;
        }

        @Override
        public _FinalStage authorId(Integer authorId) {
            this.authorId = Optional.ofNullable(authorId);
            return this;
        }

        @Override
        @JsonSetter(value="author_id", nulls=Nulls.SKIP)
        public _FinalStage authorId(Optional<Integer> authorId) {
            this.authorId = authorId;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @Override
        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public _FinalStage title(Optional<String> title) {
            this.title = title;
            return this;
        }

        @Override
        public UpdateArticleRequest build() {
            return new UpdateArticleRequest(this.articleId, this.title, this.description, this.body, this.authorId, this.state, this.parentId, this.parentType, this.translatedContent, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateArticleRequest build();

        public _FinalStage title(Optional<String> var1);

        public _FinalStage title(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage authorId(Optional<Integer> var1);

        public _FinalStage authorId(Integer var1);

        public _FinalStage state(Optional<State> var1);

        public _FinalStage state(State var1);

        public _FinalStage parentId(Optional<String> var1);

        public _FinalStage parentId(String var1);

        public _FinalStage parentType(Optional<ParentType> var1);

        public _FinalStage parentType(ParentType var1);

        public _FinalStage translatedContent(Optional<ArticleTranslatedContent> var1);

        public _FinalStage translatedContent(ArticleTranslatedContent var1);
    }

    public static interface ArticleIdStage {
        public _FinalStage articleId(@NotNull String var1);

        public Builder from(UpdateArticleRequest var1);
    }
}

