/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListAttachedContactsRequest {
    private final String companyId;
    private final Optional<Integer> page;
    private final Optional<Integer> perPage;
    private final Map<String, Object> additionalProperties;

    private ListAttachedContactsRequest(String companyId, Optional<Integer> page, Optional<Integer> perPage, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.page = page;
        this.perPage = perPage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="page")
    public Optional<Integer> getPage() {
        return this.page;
    }

    @JsonProperty(value="per_page")
    public Optional<Integer> getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListAttachedContactsRequest && this.equalTo((ListAttachedContactsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListAttachedContactsRequest other) {
        return this.companyId.equals(other.companyId) && this.page.equals(other.page) && this.perPage.equals(other.perPage);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.page, this.perPage);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    _FinalStage {
        private String companyId;
        private Optional<Integer> perPage = Optional.empty();
        private Optional<Integer> page = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListAttachedContactsRequest other) {
            this.companyId(other.getCompanyId());
            this.page(other.getPage());
            this.perPage(other.getPerPage());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public _FinalStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        public _FinalStage perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        @Override
        @JsonSetter(value="per_page", nulls=Nulls.SKIP)
        public _FinalStage perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        @Override
        public _FinalStage page(Integer page) {
            this.page = Optional.ofNullable(page);
            return this;
        }

        @Override
        @JsonSetter(value="page", nulls=Nulls.SKIP)
        public _FinalStage page(Optional<Integer> page) {
            this.page = page;
            return this;
        }

        @Override
        public ListAttachedContactsRequest build() {
            return new ListAttachedContactsRequest(this.companyId, this.page, this.perPage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListAttachedContactsRequest build();

        public _FinalStage page(Optional<Integer> var1);

        public _FinalStage page(Integer var1);

        public _FinalStage perPage(Optional<Integer> var1);

        public _FinalStage perPage(Integer var1);
    }

    public static interface CompanyIdStage {
        public _FinalStage companyId(@NotNull String var1);

        public Builder from(ListAttachedContactsRequest var1);
    }
}

