/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.contacts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MergeContactsRequest {
    private final String leadId;
    private final String contactId;
    private final Map<String, Object> additionalProperties;

    private MergeContactsRequest(String leadId, String contactId, Map<String, Object> additionalProperties) {
        this.leadId = leadId;
        this.contactId = contactId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="from")
    public String getLeadId() {
        return this.leadId;
    }

    @JsonProperty(value="into")
    public String getContactId() {
        return this.contactId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MergeContactsRequest && this.equalTo((MergeContactsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MergeContactsRequest other) {
        return this.leadId.equals(other.leadId) && this.contactId.equals(other.contactId);
    }

    public int hashCode() {
        return Objects.hash(this.leadId, this.contactId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LeadIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LeadIdStage,
    ContactIdStage,
    _FinalStage {
        private String leadId;
        private String contactId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(MergeContactsRequest other) {
            this.leadId(other.getLeadId());
            this.contactId(other.getContactId());
            return this;
        }

        @Override
        @JsonSetter(value="from")
        public ContactIdStage leadId(@NotNull String leadId) {
            this.leadId = Objects.requireNonNull(leadId, "leadId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="into")
        public _FinalStage contactId(@NotNull String contactId) {
            this.contactId = Objects.requireNonNull(contactId, "contactId must not be null");
            return this;
        }

        @Override
        public MergeContactsRequest build() {
            return new MergeContactsRequest(this.leadId, this.contactId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public MergeContactsRequest build();
    }

    public static interface ContactIdStage {
        public _FinalStage contactId(@NotNull String var1);
    }

    public static interface LeadIdStage {
        public ContactIdStage leadId(@NotNull String var1);

        public Builder from(MergeContactsRequest var1);
    }
}

