/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CustomerRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AttachContactToConversationRequest {
    private final String conversationId;
    private final Optional<String> adminId;
    private final Optional<Customer> customer;
    private final Map<String, Object> additionalProperties;

    private AttachContactToConversationRequest(String conversationId, Optional<String> adminId, Optional<Customer> customer, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.adminId = adminId;
        this.customer = customer;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="admin_id")
    public Optional<String> getAdminId() {
        return this.adminId;
    }

    @JsonProperty(value="customer")
    public Optional<Customer> getCustomer() {
        return this.customer;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AttachContactToConversationRequest && this.equalTo((AttachContactToConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachContactToConversationRequest other) {
        return this.conversationId.equals(other.conversationId) && this.adminId.equals(other.adminId) && this.customer.equals(other.customer);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.adminId, this.customer);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    @JsonDeserialize(using=Deserializer.class)
    public static final class Customer {
        private final Object value;
        private final int type;

        private Customer(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((IntercomUserId)this.value);
            }
            if (this.type == 1) {
                return visitor.visit((UserId)this.value);
            }
            if (this.type == 2) {
                return visitor.visit((Customer_)this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Customer && this.equalTo((Customer)other);
        }

        private boolean equalTo(Customer other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return this.value.toString();
        }

        public static Customer of(IntercomUserId value) {
            return new Customer(value, 0);
        }

        public static Customer of(UserId value) {
            return new Customer(value, 1);
        }

        public static Customer of(Customer_ value) {
            return new Customer(value, 2);
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class IntercomUserId {
            private final String intercomUserId;
            private final Optional<CustomerRequest> customer;
            private final Map<String, Object> additionalProperties;

            private IntercomUserId(String intercomUserId, Optional<CustomerRequest> customer, Map<String, Object> additionalProperties) {
                this.intercomUserId = intercomUserId;
                this.customer = customer;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="intercom_user_id")
            public String getIntercomUserId() {
                return this.intercomUserId;
            }

            @JsonProperty(value="customer")
            public Optional<CustomerRequest> getCustomer() {
                return this.customer;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof IntercomUserId && this.equalTo((IntercomUserId)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(IntercomUserId other) {
                return this.intercomUserId.equals(other.intercomUserId) && this.customer.equals(other.customer);
            }

            public int hashCode() {
                return Objects.hash(this.intercomUserId, this.customer);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static IntercomUserIdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements IntercomUserIdStage,
            _FinalStage {
                private String intercomUserId;
                private Optional<CustomerRequest> customer = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(IntercomUserId other) {
                    this.intercomUserId(other.getIntercomUserId());
                    this.customer(other.getCustomer());
                    return this;
                }

                @Override
                @JsonSetter(value="intercom_user_id")
                public _FinalStage intercomUserId(@NotNull String intercomUserId) {
                    this.intercomUserId = Objects.requireNonNull(intercomUserId, "intercomUserId must not be null");
                    return this;
                }

                @Override
                public _FinalStage customer(CustomerRequest customer) {
                    this.customer = Optional.ofNullable(customer);
                    return this;
                }

                @Override
                @JsonSetter(value="customer", nulls=Nulls.SKIP)
                public _FinalStage customer(Optional<CustomerRequest> customer) {
                    this.customer = customer;
                    return this;
                }

                @Override
                public IntercomUserId build() {
                    return new IntercomUserId(this.intercomUserId, this.customer, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public IntercomUserId build();

                public _FinalStage customer(Optional<CustomerRequest> var1);

                public _FinalStage customer(CustomerRequest var1);
            }

            public static interface IntercomUserIdStage {
                public _FinalStage intercomUserId(@NotNull String var1);

                public Builder from(IntercomUserId var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class Customer_ {
            private final String email;
            private final Optional<CustomerRequest> customer;
            private final Map<String, Object> additionalProperties;

            private Customer_(String email, Optional<CustomerRequest> customer, Map<String, Object> additionalProperties) {
                this.email = email;
                this.customer = customer;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="email")
            public String getEmail() {
                return this.email;
            }

            @JsonProperty(value="customer")
            public Optional<CustomerRequest> getCustomer() {
                return this.customer;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof Customer_ && this.equalTo((Customer_)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(Customer_ other) {
                return this.email.equals(other.email) && this.customer.equals(other.customer);
            }

            public int hashCode() {
                return Objects.hash(this.email, this.customer);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static EmailStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements EmailStage,
            _FinalStage {
                private String email;
                private Optional<CustomerRequest> customer = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(Customer_ other) {
                    this.email(other.getEmail());
                    this.customer(other.getCustomer());
                    return this;
                }

                @Override
                @JsonSetter(value="email")
                public _FinalStage email(@NotNull String email) {
                    this.email = Objects.requireNonNull(email, "email must not be null");
                    return this;
                }

                @Override
                public _FinalStage customer(CustomerRequest customer) {
                    this.customer = Optional.ofNullable(customer);
                    return this;
                }

                @Override
                @JsonSetter(value="customer", nulls=Nulls.SKIP)
                public _FinalStage customer(Optional<CustomerRequest> customer) {
                    this.customer = customer;
                    return this;
                }

                @Override
                public Customer_ build() {
                    return new Customer_(this.email, this.customer, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public Customer_ build();

                public _FinalStage customer(Optional<CustomerRequest> var1);

                public _FinalStage customer(CustomerRequest var1);
            }

            public static interface EmailStage {
                public _FinalStage email(@NotNull String var1);

                public Builder from(Customer_ var1);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        @JsonDeserialize(builder=Builder.class)
        public static final class UserId {
            private final String userId;
            private final Optional<CustomerRequest> customer;
            private final Map<String, Object> additionalProperties;

            private UserId(String userId, Optional<CustomerRequest> customer, Map<String, Object> additionalProperties) {
                this.userId = userId;
                this.customer = customer;
                this.additionalProperties = additionalProperties;
            }

            @JsonProperty(value="user_id")
            public String getUserId() {
                return this.userId;
            }

            @JsonProperty(value="customer")
            public Optional<CustomerRequest> getCustomer() {
                return this.customer;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                return other instanceof UserId && this.equalTo((UserId)other);
            }

            @JsonAnyGetter
            public Map<String, Object> getAdditionalProperties() {
                return this.additionalProperties;
            }

            private boolean equalTo(UserId other) {
                return this.userId.equals(other.userId) && this.customer.equals(other.customer);
            }

            public int hashCode() {
                return Objects.hash(this.userId, this.customer);
            }

            public String toString() {
                return ObjectMappers.stringify(this);
            }

            public static UserIdStage builder() {
                return new Builder();
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            public static final class Builder
            implements UserIdStage,
            _FinalStage {
                private String userId;
                private Optional<CustomerRequest> customer = Optional.empty();
                @JsonAnySetter
                private Map<String, Object> additionalProperties = new HashMap<String, Object>();

                private Builder() {
                }

                @Override
                public Builder from(UserId other) {
                    this.userId(other.getUserId());
                    this.customer(other.getCustomer());
                    return this;
                }

                @Override
                @JsonSetter(value="user_id")
                public _FinalStage userId(@NotNull String userId) {
                    this.userId = Objects.requireNonNull(userId, "userId must not be null");
                    return this;
                }

                @Override
                public _FinalStage customer(CustomerRequest customer) {
                    this.customer = Optional.ofNullable(customer);
                    return this;
                }

                @Override
                @JsonSetter(value="customer", nulls=Nulls.SKIP)
                public _FinalStage customer(Optional<CustomerRequest> customer) {
                    this.customer = customer;
                    return this;
                }

                @Override
                public UserId build() {
                    return new UserId(this.userId, this.customer, this.additionalProperties);
                }
            }

            public static interface _FinalStage {
                public UserId build();

                public _FinalStage customer(Optional<CustomerRequest> var1);

                public _FinalStage customer(CustomerRequest var1);
            }

            public static interface UserIdStage {
                public _FinalStage userId(@NotNull String var1);

                public Builder from(UserId var1);
            }
        }

        static final class Deserializer
        extends StdDeserializer<Customer> {
            Deserializer() {
                super(Customer.class);
            }

            public Customer deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return Customer.of((IntercomUserId)ObjectMappers.JSON_MAPPER.convertValue(value, IntercomUserId.class));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        return Customer.of((UserId)ObjectMappers.JSON_MAPPER.convertValue(value, UserId.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        try {
                            return Customer.of((Customer_)ObjectMappers.JSON_MAPPER.convertValue(value, Customer_.class));
                        }
                        catch (IllegalArgumentException illegalArgumentException3) {
                            throw new JsonParseException(p, "Failed to deserialize");
                        }
                    }
                }
            }
        }

        public static interface Visitor<T> {
            public T visit(IntercomUserId var1);

            public T visit(UserId var1);

            public T visit(Customer_ var1);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConversationIdStage,
    _FinalStage {
        private String conversationId;
        private Optional<Customer> customer = Optional.empty();
        private Optional<String> adminId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AttachContactToConversationRequest other) {
            this.conversationId(other.getConversationId());
            this.adminId(other.getAdminId());
            this.customer(other.getCustomer());
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public _FinalStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        public _FinalStage customer(Customer customer) {
            this.customer = Optional.ofNullable(customer);
            return this;
        }

        @Override
        @JsonSetter(value="customer", nulls=Nulls.SKIP)
        public _FinalStage customer(Optional<Customer> customer) {
            this.customer = customer;
            return this;
        }

        @Override
        public _FinalStage adminId(String adminId) {
            this.adminId = Optional.ofNullable(adminId);
            return this;
        }

        @Override
        @JsonSetter(value="admin_id", nulls=Nulls.SKIP)
        public _FinalStage adminId(Optional<String> adminId) {
            this.adminId = adminId;
            return this;
        }

        @Override
        public AttachContactToConversationRequest build() {
            return new AttachContactToConversationRequest(this.conversationId, this.adminId, this.customer, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AttachContactToConversationRequest build();

        public _FinalStage adminId(Optional<String> var1);

        public _FinalStage adminId(String var1);

        public _FinalStage customer(Optional<Customer> var1);

        public _FinalStage customer(Customer var1);
    }

    public static interface ConversationIdStage {
        public _FinalStage conversationId(@NotNull String var1);

        public Builder from(AttachContactToConversationRequest var1);
    }
}

