/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intercom.api.types.AssignConversationRequest;
import com.intercom.api.types.CloseConversationRequest;
import com.intercom.api.types.OpenConversationRequest;
import com.intercom.api.types.SnoozeConversationRequest;
import java.util.Objects;
import java.util.Optional;

public final class ConversationsManageRequestBody {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private ConversationsManageRequestBody(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static ConversationsManageRequestBody close(CloseConversationRequest value) {
        return new ConversationsManageRequestBody(new CloseValue(value));
    }

    public static ConversationsManageRequestBody snoozed(SnoozeConversationRequest value) {
        return new ConversationsManageRequestBody(new SnoozedValue(value));
    }

    public static ConversationsManageRequestBody open(OpenConversationRequest value) {
        return new ConversationsManageRequestBody(new OpenValue(value));
    }

    public static ConversationsManageRequestBody assignment(AssignConversationRequest value) {
        return new ConversationsManageRequestBody(new AssignmentValue(value));
    }

    public boolean isClose() {
        return this.value instanceof CloseValue;
    }

    public boolean isSnoozed() {
        return this.value instanceof SnoozedValue;
    }

    public boolean isOpen() {
        return this.value instanceof OpenValue;
    }

    public boolean isAssignment() {
        return this.value instanceof AssignmentValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<CloseConversationRequest> getClose() {
        if (this.isClose()) {
            return Optional.of(((CloseValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<SnoozeConversationRequest> getSnoozed() {
        if (this.isSnoozed()) {
            return Optional.of(((SnoozedValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<OpenConversationRequest> getOpen() {
        if (this.isOpen()) {
            return Optional.of(((OpenValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<AssignConversationRequest> getAssignment() {
        if (this.isAssignment()) {
            return Optional.of(((AssignmentValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"message_type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "ConversationsManageRequestBody{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="assignment")
    @JsonIgnoreProperties(value={"message_type"})
    private static final class AssignmentValue
    implements Value {
        @JsonUnwrapped
        private AssignConversationRequest value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private AssignmentValue() {
        }

        private AssignmentValue(AssignConversationRequest value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitAssignment(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof AssignmentValue && this.equalTo((AssignmentValue)other);
        }

        private boolean equalTo(AssignmentValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ConversationsManageRequestBody{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="open")
    @JsonIgnoreProperties(value={"message_type"})
    private static final class OpenValue
    implements Value {
        @JsonUnwrapped
        private OpenConversationRequest value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private OpenValue() {
        }

        private OpenValue(OpenConversationRequest value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitOpen(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof OpenValue && this.equalTo((OpenValue)other);
        }

        private boolean equalTo(OpenValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ConversationsManageRequestBody{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="snoozed")
    @JsonIgnoreProperties(value={"message_type"})
    private static final class SnoozedValue
    implements Value {
        @JsonUnwrapped
        private SnoozeConversationRequest value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SnoozedValue() {
        }

        private SnoozedValue(SnoozeConversationRequest value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSnoozed(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SnoozedValue && this.equalTo((SnoozedValue)other);
        }

        private boolean equalTo(SnoozedValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ConversationsManageRequestBody{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="close")
    @JsonIgnoreProperties(value={"message_type"})
    private static final class CloseValue
    implements Value {
        @JsonUnwrapped
        private CloseConversationRequest value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CloseValue() {
        }

        private CloseValue(CloseConversationRequest value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitClose(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CloseValue && this.equalTo((CloseValue)other);
        }

        private boolean equalTo(CloseValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "ConversationsManageRequestBody{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="message_type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CloseValue.class), @JsonSubTypes.Type(value=SnoozedValue.class), @JsonSubTypes.Type(value=OpenValue.class), @JsonSubTypes.Type(value=AssignmentValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitClose(CloseConversationRequest var1);

        public T visitSnoozed(SnoozeConversationRequest var1);

        public T visitOpen(OpenConversationRequest var1);

        public T visitAssignment(AssignConversationRequest var1);

        public T _visitUnknown(Object var1);
    }
}

