/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.dataexport;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.dataexport.AsyncRawDataExportClient;
import com.intercom.api.resources.dataexport.requests.CancelDataExportRequest;
import com.intercom.api.resources.dataexport.requests.CreateDataExportRequest;
import com.intercom.api.resources.dataexport.requests.DownloadDataExportRequest;
import com.intercom.api.resources.dataexport.requests.FindDataExportRequest;
import com.intercom.api.resources.dataexport.types.DataExport;
import java.util.concurrent.CompletableFuture;

public class AsyncDataExportClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDataExportClient rawClient;

    public AsyncDataExportClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDataExportClient(clientOptions);
    }

    public AsyncRawDataExportClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<DataExport> create(CreateDataExportRequest request) {
        return this.rawClient.create(request).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> create(CreateDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> find(FindDataExportRequest request) {
        return this.rawClient.find(request).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> find(FindDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> cancel(CancelDataExportRequest request) {
        return this.rawClient.cancel(request).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<DataExport> cancel(CancelDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).thenApply(response -> (DataExport)response.body());
    }

    public CompletableFuture<Void> download(DownloadDataExportRequest request) {
        return this.rawClient.download(request).thenApply(response -> (Void)response.body());
    }

    public CompletableFuture<Void> download(DownloadDataExportRequest request, RequestOptions requestOptions) {
        return this.rawClient.download(request, requestOptions).thenApply(response -> (Void)response.body());
    }
}

