/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class HelpCenter {
    private final String id;
    private final String workspaceId;
    private final int createdAt;
    private final Optional<Integer> updatedAt;
    private final String identifier;
    private final boolean websiteTurnedOn;
    private final String displayName;
    private final Map<String, Object> additionalProperties;

    private HelpCenter(String id, String workspaceId, int createdAt, Optional<Integer> updatedAt, String identifier, boolean websiteTurnedOn, String displayName, Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.identifier = identifier;
        this.websiteTurnedOn = websiteTurnedOn;
        this.displayName = displayName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @JsonProperty(value="website_turned_on")
    public boolean getWebsiteTurnedOn() {
        return this.websiteTurnedOn;
    }

    @JsonProperty(value="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof HelpCenter && this.equalTo((HelpCenter)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HelpCenter other) {
        return this.id.equals(other.id) && this.workspaceId.equals(other.workspaceId) && this.createdAt == other.createdAt && this.updatedAt.equals(other.updatedAt) && this.identifier.equals(other.identifier) && this.websiteTurnedOn == other.websiteTurnedOn && this.displayName.equals(other.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.workspaceId, this.createdAt, this.updatedAt, this.identifier, this.websiteTurnedOn, this.displayName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    WorkspaceIdStage,
    CreatedAtStage,
    IdentifierStage,
    WebsiteTurnedOnStage,
    DisplayNameStage,
    _FinalStage {
        private String id;
        private String workspaceId;
        private int createdAt;
        private String identifier;
        private boolean websiteTurnedOn;
        private String displayName;
        private Optional<Integer> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(HelpCenter other) {
            this.id(other.getId());
            this.workspaceId(other.getWorkspaceId());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.identifier(other.getIdentifier());
            this.websiteTurnedOn(other.getWebsiteTurnedOn());
            this.displayName(other.getDisplayName());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public CreatedAtStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IdentifierStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="identifier")
        public WebsiteTurnedOnStage identifier(@NotNull String identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="website_turned_on")
        public DisplayNameStage websiteTurnedOn(boolean websiteTurnedOn) {
            this.websiteTurnedOn = websiteTurnedOn;
            return this;
        }

        @Override
        @JsonSetter(value="display_name")
        public _FinalStage displayName(@NotNull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName must not be null");
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public HelpCenter build() {
            return new HelpCenter(this.id, this.workspaceId, this.createdAt, this.updatedAt, this.identifier, this.websiteTurnedOn, this.displayName, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public HelpCenter build();

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);
    }

    public static interface DisplayNameStage {
        public _FinalStage displayName(@NotNull String var1);
    }

    public static interface WebsiteTurnedOnStage {
        public DisplayNameStage websiteTurnedOn(boolean var1);
    }

    public static interface IdentifierStage {
        public WebsiteTurnedOnStage identifier(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public IdentifierStage createdAt(int var1);
    }

    public static interface WorkspaceIdStage {
        public CreatedAtStage workspaceId(@NotNull String var1);
    }

    public static interface IdStage {
        public WorkspaceIdStage id(@NotNull String var1);

        public Builder from(HelpCenter var1);
    }
}

