/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.notes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Note {
    private final String id;
    private final int createdAt;
    private final Optional<Contact> contact;
    private final Admin author;
    private final String body;
    private final Map<String, Object> additionalProperties;

    private Note(String id, int createdAt, Optional<Contact> contact, Admin author, String body, Map<String, Object> additionalProperties) {
        this.id = id;
        this.createdAt = createdAt;
        this.contact = contact;
        this.author = author;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "note";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="contact")
    public Optional<Contact> getContact() {
        return this.contact;
    }

    @JsonProperty(value="author")
    public Admin getAuthor() {
        return this.author;
    }

    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Note && this.equalTo((Note)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Note other) {
        return this.id.equals(other.id) && this.createdAt == other.createdAt && this.contact.equals(other.contact) && this.author.equals(other.author) && this.body.equals(other.body);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.contact, this.author, this.body);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Contact {
        private final Optional<String> type;
        private final Optional<String> id;
        private final Map<String, Object> additionalProperties;

        private Contact(Optional<String> type, Optional<String> id, Map<String, Object> additionalProperties) {
            this.type = type;
            this.id = id;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="type")
        public Optional<String> getType() {
            return this.type;
        }

        @JsonProperty(value="id")
        public Optional<String> getId() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Contact && this.equalTo((Contact)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Contact other) {
            return this.type.equals(other.type) && this.id.equals(other.id);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.id);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder {
            private Optional<String> type = Optional.empty();
            private Optional<String> id = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            public Builder from(Contact other) {
                this.type(other.getType());
                this.id(other.getId());
                return this;
            }

            @JsonSetter(value="type", nulls=Nulls.SKIP)
            public Builder type(Optional<String> type) {
                this.type = type;
                return this;
            }

            public Builder type(String type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            @JsonSetter(value="id", nulls=Nulls.SKIP)
            public Builder id(Optional<String> id) {
                this.id = id;
                return this;
            }

            public Builder id(String id) {
                this.id = Optional.ofNullable(id);
                return this;
            }

            public Contact build() {
                return new Contact(this.type, this.id, this.additionalProperties);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    CreatedAtStage,
    AuthorStage,
    BodyStage,
    _FinalStage {
        private String id;
        private int createdAt;
        private Admin author;
        private String body;
        private Optional<Contact> contact = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Note other) {
            this.id(other.getId());
            this.createdAt(other.getCreatedAt());
            this.contact(other.getContact());
            this.author(other.getAuthor());
            this.body(other.getBody());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public AuthorStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="author")
        public BodyStage author(@NotNull Admin author) {
            this.author = Objects.requireNonNull(author, "author must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public _FinalStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        public _FinalStage contact(Contact contact) {
            this.contact = Optional.ofNullable(contact);
            return this;
        }

        @Override
        @JsonSetter(value="contact", nulls=Nulls.SKIP)
        public _FinalStage contact(Optional<Contact> contact) {
            this.contact = contact;
            return this;
        }

        @Override
        public Note build() {
            return new Note(this.id, this.createdAt, this.contact, this.author, this.body, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Note build();

        public _FinalStage contact(Optional<Contact> var1);

        public _FinalStage contact(Contact var1);
    }

    public static interface BodyStage {
        public _FinalStage body(@NotNull String var1);
    }

    public static interface AuthorStage {
        public BodyStage author(@NotNull Admin var1);
    }

    public static interface CreatedAtStage {
        public AuthorStage createdAt(int var1);
    }

    public static interface IdStage {
        public CreatedAtStage id(@NotNull String var1);

        public Builder from(Note var1);
    }
}

