/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.subscriptiontypes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SubscriptionType {
    private final String id;
    private final State state;
    private final Translation defaultTranslation;
    private final List<Translation> translations;
    private final ConsentType consentType;
    private final List<ContentTypesItem> contentTypes;
    private final Map<String, Object> additionalProperties;

    private SubscriptionType(String id, State state, Translation defaultTranslation, List<Translation> translations, ConsentType consentType, List<ContentTypesItem> contentTypes, Map<String, Object> additionalProperties) {
        this.id = id;
        this.state = state;
        this.defaultTranslation = defaultTranslation;
        this.translations = translations;
        this.consentType = consentType;
        this.contentTypes = contentTypes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "subscription";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="state")
    public State getState() {
        return this.state;
    }

    @JsonProperty(value="default_translation")
    public Translation getDefaultTranslation() {
        return this.defaultTranslation;
    }

    @JsonProperty(value="translations")
    public List<Translation> getTranslations() {
        return this.translations;
    }

    @JsonProperty(value="consent_type")
    public ConsentType getConsentType() {
        return this.consentType;
    }

    @JsonProperty(value="content_types")
    public List<ContentTypesItem> getContentTypes() {
        return this.contentTypes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SubscriptionType && this.equalTo((SubscriptionType)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionType other) {
        return this.id.equals(other.id) && this.state.equals(other.state) && this.defaultTranslation.equals(other.defaultTranslation) && this.translations.equals(other.translations) && this.consentType.equals(other.consentType) && this.contentTypes.equals(other.contentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.state, this.defaultTranslation, this.translations, this.consentType, this.contentTypes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class ContentTypesItem {
        public static final ContentTypesItem EMAIL = new ContentTypesItem(Value.EMAIL, "email");
        public static final ContentTypesItem SMS_MESSAGE = new ContentTypesItem(Value.SMS_MESSAGE, "sms_message");
        private final Value value;
        private final String string;

        ContentTypesItem(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ContentTypesItem && this.string.equals(((ContentTypesItem)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case EMAIL: {
                    return visitor.visitEmail();
                }
                case SMS_MESSAGE: {
                    return visitor.visitSmsMessage();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static ContentTypesItem valueOf(String value) {
            switch (value) {
                case "email": {
                    return EMAIL;
                }
                case "sms_message": {
                    return SMS_MESSAGE;
                }
            }
            return new ContentTypesItem(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitEmail();

            public T visitSmsMessage();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            EMAIL,
            SMS_MESSAGE,
            UNKNOWN;

        }
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");
        public static final State ARCHIVED = new State(Value.ARCHIVED, "archived");
        public static final State DRAFT = new State(Value.DRAFT, "draft");
        private final Value value;
        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof State && this.string.equals(((State)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case LIVE: {
                    return visitor.visitLive();
                }
                case ARCHIVED: {
                    return visitor.visitArchived();
                }
                case DRAFT: {
                    return visitor.visitDraft();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live": {
                    return LIVE;
                }
                case "archived": {
                    return ARCHIVED;
                }
                case "draft": {
                    return DRAFT;
                }
            }
            return new State(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitLive();

            public T visitDraft();

            public T visitArchived();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            LIVE,
            DRAFT,
            ARCHIVED,
            UNKNOWN;

        }
    }

    public static final class ConsentType {
        public static final ConsentType OPT_IN = new ConsentType(Value.OPT_IN, "opt_in");
        public static final ConsentType OPT_OUT = new ConsentType(Value.OPT_OUT, "opt_out");
        private final Value value;
        private final String string;

        ConsentType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ConsentType && this.string.equals(((ConsentType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case OPT_IN: {
                    return visitor.visitOptIn();
                }
                case OPT_OUT: {
                    return visitor.visitOptOut();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static ConsentType valueOf(String value) {
            switch (value) {
                case "opt_in": {
                    return OPT_IN;
                }
                case "opt_out": {
                    return OPT_OUT;
                }
            }
            return new ConsentType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitOptOut();

            public T visitOptIn();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            OPT_OUT,
            OPT_IN,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    StateStage,
    DefaultTranslationStage,
    ConsentTypeStage,
    _FinalStage {
        private String id;
        private State state;
        private Translation defaultTranslation;
        private ConsentType consentType;
        private List<ContentTypesItem> contentTypes = new ArrayList<ContentTypesItem>();
        private List<Translation> translations = new ArrayList<Translation>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SubscriptionType other) {
            this.id(other.getId());
            this.state(other.getState());
            this.defaultTranslation(other.getDefaultTranslation());
            this.translations(other.getTranslations());
            this.consentType(other.getConsentType());
            this.contentTypes(other.getContentTypes());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public StateStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="state")
        public DefaultTranslationStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="default_translation")
        public ConsentTypeStage defaultTranslation(@NotNull Translation defaultTranslation) {
            this.defaultTranslation = Objects.requireNonNull(defaultTranslation, "defaultTranslation must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="consent_type")
        public _FinalStage consentType(@NotNull ConsentType consentType) {
            this.consentType = Objects.requireNonNull(consentType, "consentType must not be null");
            return this;
        }

        @Override
        public _FinalStage addAllContentTypes(List<ContentTypesItem> contentTypes) {
            this.contentTypes.addAll(contentTypes);
            return this;
        }

        @Override
        public _FinalStage addContentTypes(ContentTypesItem contentTypes) {
            this.contentTypes.add(contentTypes);
            return this;
        }

        @Override
        @JsonSetter(value="content_types", nulls=Nulls.SKIP)
        public _FinalStage contentTypes(List<ContentTypesItem> contentTypes) {
            this.contentTypes.clear();
            this.contentTypes.addAll(contentTypes);
            return this;
        }

        @Override
        public _FinalStage addAllTranslations(List<Translation> translations) {
            this.translations.addAll(translations);
            return this;
        }

        @Override
        public _FinalStage addTranslations(Translation translations) {
            this.translations.add(translations);
            return this;
        }

        @Override
        @JsonSetter(value="translations", nulls=Nulls.SKIP)
        public _FinalStage translations(List<Translation> translations) {
            this.translations.clear();
            this.translations.addAll(translations);
            return this;
        }

        @Override
        public SubscriptionType build() {
            return new SubscriptionType(this.id, this.state, this.defaultTranslation, this.translations, this.consentType, this.contentTypes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SubscriptionType build();

        public _FinalStage translations(List<Translation> var1);

        public _FinalStage addTranslations(Translation var1);

        public _FinalStage addAllTranslations(List<Translation> var1);

        public _FinalStage contentTypes(List<ContentTypesItem> var1);

        public _FinalStage addContentTypes(ContentTypesItem var1);

        public _FinalStage addAllContentTypes(List<ContentTypesItem> var1);
    }

    public static interface ConsentTypeStage {
        public _FinalStage consentType(@NotNull ConsentType var1);
    }

    public static interface DefaultTranslationStage {
        public ConsentTypeStage defaultTranslation(@NotNull Translation var1);
    }

    public static interface StateStage {
        public DefaultTranslationStage state(@NotNull State var1);
    }

    public static interface IdStage {
        public StateStage id(@NotNull String var1);

        public Builder from(SubscriptionType var1);
    }
}

