/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tags.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TagTicketRequest {
    private final String ticketId;
    private final String tagId;
    private final String adminId;
    private final Map<String, Object> additionalProperties;

    private TagTicketRequest(String ticketId, String tagId, String adminId, Map<String, Object> additionalProperties) {
        this.ticketId = ticketId;
        this.tagId = tagId;
        this.adminId = adminId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ticket_id")
    public String getTicketId() {
        return this.ticketId;
    }

    @JsonProperty(value="id")
    public String getTagId() {
        return this.tagId;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TagTicketRequest && this.equalTo((TagTicketRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TagTicketRequest other) {
        return this.ticketId.equals(other.ticketId) && this.tagId.equals(other.tagId) && this.adminId.equals(other.adminId);
    }

    public int hashCode() {
        return Objects.hash(this.ticketId, this.tagId, this.adminId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TicketIdStage,
    TagIdStage,
    AdminIdStage,
    _FinalStage {
        private String ticketId;
        private String tagId;
        private String adminId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TagTicketRequest other) {
            this.ticketId(other.getTicketId());
            this.tagId(other.getTagId());
            this.adminId(other.getAdminId());
            return this;
        }

        @Override
        @JsonSetter(value="ticket_id")
        public TagIdStage ticketId(@NotNull String ticketId) {
            this.ticketId = Objects.requireNonNull(ticketId, "ticketId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public AdminIdStage tagId(@NotNull String tagId) {
            this.tagId = Objects.requireNonNull(tagId, "tagId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public _FinalStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        public TagTicketRequest build() {
            return new TagTicketRequest(this.ticketId, this.tagId, this.adminId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TagTicketRequest build();
    }

    public static interface AdminIdStage {
        public _FinalStage adminId(@NotNull String var1);
    }

    public static interface TagIdStage {
        public AdminIdStage tagId(@NotNull String var1);
    }

    public static interface TicketIdStage {
        public TagIdStage ticketId(@NotNull String var1);

        public Builder from(TagTicketRequest var1);
    }
}

