/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.TicketTypeAttributeList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketType {
    private final String id;
    private final Category category;
    private final String name;
    private final String description;
    private final String icon;
    private final String workspaceId;
    private final TicketTypeAttributeList ticketTypeAttributes;
    private final boolean archived;
    private final int createdAt;
    private final Optional<Integer> updatedAt;
    private final Map<String, Object> additionalProperties;

    private TicketType(String id, Category category, String name, String description, String icon, String workspaceId, TicketTypeAttributeList ticketTypeAttributes, boolean archived, int createdAt, Optional<Integer> updatedAt, Map<String, Object> additionalProperties) {
        this.id = id;
        this.category = category;
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.workspaceId = workspaceId;
        this.ticketTypeAttributes = ticketTypeAttributes;
        this.archived = archived;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "ticket_type";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="ticket_type_attributes")
    public TicketTypeAttributeList getTicketTypeAttributes() {
        return this.ticketTypeAttributes;
    }

    @JsonProperty(value="archived")
    public boolean getArchived() {
        return this.archived;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketType && this.equalTo((TicketType)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketType other) {
        return this.id.equals(other.id) && this.category.equals(other.category) && this.name.equals(other.name) && this.description.equals(other.description) && this.icon.equals(other.icon) && this.workspaceId.equals(other.workspaceId) && this.ticketTypeAttributes.equals(other.ticketTypeAttributes) && this.archived == other.archived && this.createdAt == other.createdAt && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.category, this.name, this.description, this.icon, this.workspaceId, this.ticketTypeAttributes, this.archived, this.createdAt, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");
        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");
        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");
        private final Value value;
        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Category && this.string.equals(((Category)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case BACK_OFFICE: {
                    return visitor.visitBackOffice();
                }
                case CUSTOMER: {
                    return visitor.visitCustomer();
                }
                case TRACKER: {
                    return visitor.visitTracker();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office": {
                    return BACK_OFFICE;
                }
                case "Customer": {
                    return CUSTOMER;
                }
                case "Tracker": {
                    return TRACKER;
                }
            }
            return new Category(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitCustomer();

            public T visitBackOffice();

            public T visitTracker();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CUSTOMER,
            BACK_OFFICE,
            TRACKER,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    CategoryStage,
    NameStage,
    DescriptionStage,
    IconStage,
    WorkspaceIdStage,
    TicketTypeAttributesStage,
    ArchivedStage,
    CreatedAtStage,
    _FinalStage {
        private String id;
        private Category category;
        private String name;
        private String description;
        private String icon;
        private String workspaceId;
        private TicketTypeAttributeList ticketTypeAttributes;
        private boolean archived;
        private int createdAt;
        private Optional<Integer> updatedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TicketType other) {
            this.id(other.getId());
            this.category(other.getCategory());
            this.name(other.getName());
            this.description(other.getDescription());
            this.icon(other.getIcon());
            this.workspaceId(other.getWorkspaceId());
            this.ticketTypeAttributes(other.getTicketTypeAttributes());
            this.archived(other.getArchived());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public CategoryStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="category")
        public NameStage category(@NotNull Category category) {
            this.category = Objects.requireNonNull(category, "category must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public DescriptionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="icon")
        public WorkspaceIdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public TicketTypeAttributesStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="ticket_type_attributes")
        public ArchivedStage ticketTypeAttributes(@NotNull TicketTypeAttributeList ticketTypeAttributes) {
            this.ticketTypeAttributes = Objects.requireNonNull(ticketTypeAttributes, "ticketTypeAttributes must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="archived")
        public CreatedAtStage archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public TicketType build() {
            return new TicketType(this.id, this.category, this.name, this.description, this.icon, this.workspaceId, this.ticketTypeAttributes, this.archived, this.createdAt, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TicketType build();

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);
    }

    public static interface CreatedAtStage {
        public _FinalStage createdAt(int var1);
    }

    public static interface ArchivedStage {
        public CreatedAtStage archived(boolean var1);
    }

    public static interface TicketTypeAttributesStage {
        public ArchivedStage ticketTypeAttributes(@NotNull TicketTypeAttributeList var1);
    }

    public static interface WorkspaceIdStage {
        public TicketTypeAttributesStage workspaceId(@NotNull String var1);
    }

    public static interface IconStage {
        public WorkspaceIdStage icon(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public IconStage description(@NotNull String var1);
    }

    public static interface NameStage {
        public DescriptionStage name(@NotNull String var1);
    }

    public static interface CategoryStage {
        public NameStage category(@NotNull Category var1);
    }

    public static interface IdStage {
        public CategoryStage id(@NotNull String var1);

        public Builder from(TicketType var1);
    }
}

