/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateContentImportSourceRequest {
    private final String id;
    private final SyncBehavior syncBehavior;
    private final Optional<Status> status;
    private final String url;
    private final Map<String, Object> additionalProperties;

    private UpdateContentImportSourceRequest(String id, SyncBehavior syncBehavior, Optional<Status> status, String url, Map<String, Object> additionalProperties) {
        this.id = id;
        this.syncBehavior = syncBehavior;
        this.status = status;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="sync_behavior")
    public SyncBehavior getSyncBehavior() {
        return this.syncBehavior;
    }

    @JsonProperty(value="status")
    public Optional<Status> getStatus() {
        return this.status;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateContentImportSourceRequest && this.equalTo((UpdateContentImportSourceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateContentImportSourceRequest other) {
        return this.id.equals(other.id) && this.syncBehavior.equals(other.syncBehavior) && this.status.equals(other.status) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.syncBehavior, this.status, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class SyncBehavior {
        public static final SyncBehavior AUTOMATED = new SyncBehavior(Value.AUTOMATED, "automated");
        public static final SyncBehavior MANUAL = new SyncBehavior(Value.MANUAL, "manual");
        public static final SyncBehavior API = new SyncBehavior(Value.API, "api");
        private final Value value;
        private final String string;

        SyncBehavior(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SyncBehavior && this.string.equals(((SyncBehavior)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case AUTOMATED: {
                    return visitor.visitAutomated();
                }
                case MANUAL: {
                    return visitor.visitManual();
                }
                case API: {
                    return visitor.visitApi();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static SyncBehavior valueOf(String value) {
            switch (value) {
                case "automated": {
                    return AUTOMATED;
                }
                case "manual": {
                    return MANUAL;
                }
                case "api": {
                    return API;
                }
            }
            return new SyncBehavior(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitApi();

            public T visitAutomated();

            public T visitManual();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            API,
            AUTOMATED,
            MANUAL,
            UNKNOWN;

        }
    }

    public static final class Status {
        public static final Status DEACTIVATED = new Status(Value.DEACTIVATED, "deactivated");
        public static final Status ACTIVE = new Status(Value.ACTIVE, "active");
        private final Value value;
        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Status && this.string.equals(((Status)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case DEACTIVATED: {
                    return visitor.visitDeactivated();
                }
                case ACTIVE: {
                    return visitor.visitActive();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "deactivated": {
                    return DEACTIVATED;
                }
                case "active": {
                    return ACTIVE;
                }
            }
            return new Status(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitActive();

            public T visitDeactivated();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ACTIVE,
            DEACTIVATED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    SyncBehaviorStage,
    UrlStage,
    _FinalStage {
        private String id;
        private SyncBehavior syncBehavior;
        private String url;
        private Optional<Status> status = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateContentImportSourceRequest other) {
            this.id(other.getId());
            this.syncBehavior(other.getSyncBehavior());
            this.status(other.getStatus());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public SyncBehaviorStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="sync_behavior")
        public UrlStage syncBehavior(@NotNull SyncBehavior syncBehavior) {
            this.syncBehavior = Objects.requireNonNull(syncBehavior, "syncBehavior must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public _FinalStage status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @Override
        @JsonSetter(value="status", nulls=Nulls.SKIP)
        public _FinalStage status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        @Override
        public UpdateContentImportSourceRequest build() {
            return new UpdateContentImportSourceRequest(this.id, this.syncBehavior, this.status, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateContentImportSourceRequest build();

        public _FinalStage status(Optional<Status> var1);

        public _FinalStage status(Status var1);
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);
    }

    public static interface SyncBehaviorStage {
        public UrlStage syncBehavior(@NotNull SyncBehavior var1);
    }

    public static interface IdStage {
        public SyncBehaviorStage id(@NotNull String var1);

        public Builder from(UpdateContentImportSourceRequest var1);
    }
}

