/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.aicontentsource.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentSource {
    private final Optional<ContentType> contentType;
    private final Optional<String> url;
    private final Optional<String> title;
    private final Optional<String> locale;
    private final Map<String, Object> additionalProperties;

    private ContentSource(Optional<ContentType> contentType, Optional<String> url, Optional<String> title, Optional<String> locale, Map<String, Object> additionalProperties) {
        this.contentType = contentType;
        this.url = url;
        this.title = title;
        this.locale = locale;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="content_type")
    public Optional<ContentType> getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    @JsonProperty(value="locale")
    public Optional<String> getLocale() {
        return this.locale;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentSource && this.equalTo((ContentSource)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSource other) {
        return this.contentType.equals(other.contentType) && this.url.equals(other.url) && this.title.equals(other.title) && this.locale.equals(other.locale);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.url, this.title, this.locale);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class ContentType {
        public static final ContentType ARTICLE = new ContentType(Value.ARTICLE, "article");
        public static final ContentType WORKFLOW_CONNECTOR_ACTION = new ContentType(Value.WORKFLOW_CONNECTOR_ACTION, "workflow_connector_action");
        public static final ContentType EXTERNAL_CONTENT = new ContentType(Value.EXTERNAL_CONTENT, "external_content");
        public static final ContentType FILE = new ContentType(Value.FILE, "file");
        public static final ContentType CONTENT_SNIPPET = new ContentType(Value.CONTENT_SNIPPET, "content_snippet");
        private final Value value;
        private final String string;

        ContentType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof ContentType && this.string.equals(((ContentType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case ARTICLE: {
                    return visitor.visitArticle();
                }
                case WORKFLOW_CONNECTOR_ACTION: {
                    return visitor.visitWorkflowConnectorAction();
                }
                case EXTERNAL_CONTENT: {
                    return visitor.visitExternalContent();
                }
                case FILE: {
                    return visitor.visitFile();
                }
                case CONTENT_SNIPPET: {
                    return visitor.visitContentSnippet();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static ContentType valueOf(String value) {
            switch (value) {
                case "article": {
                    return ARTICLE;
                }
                case "workflow_connector_action": {
                    return WORKFLOW_CONNECTOR_ACTION;
                }
                case "external_content": {
                    return EXTERNAL_CONTENT;
                }
                case "file": {
                    return FILE;
                }
                case "content_snippet": {
                    return CONTENT_SNIPPET;
                }
            }
            return new ContentType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitFile();

            public T visitArticle();

            public T visitExternalContent();

            public T visitContentSnippet();

            public T visitWorkflowConnectorAction();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            FILE,
            ARTICLE,
            EXTERNAL_CONTENT,
            CONTENT_SNIPPET,
            WORKFLOW_CONNECTOR_ACTION,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<ContentType> contentType = Optional.empty();
        private Optional<String> url = Optional.empty();
        private Optional<String> title = Optional.empty();
        private Optional<String> locale = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ContentSource other) {
            this.contentType(other.getContentType());
            this.url(other.getUrl());
            this.title(other.getTitle());
            this.locale(other.getLocale());
            return this;
        }

        @JsonSetter(value="content_type", nulls=Nulls.SKIP)
        public Builder contentType(Optional<ContentType> contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder contentType(ContentType contentType) {
            this.contentType = Optional.ofNullable(contentType);
            return this;
        }

        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public Builder url(Optional<String> url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @JsonSetter(value="title", nulls=Nulls.SKIP)
        public Builder title(Optional<String> title) {
            this.title = title;
            return this;
        }

        public Builder title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        @JsonSetter(value="locale", nulls=Nulls.SKIP)
        public Builder locale(Optional<String> locale) {
            this.locale = locale;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = Optional.ofNullable(locale);
            return this;
        }

        public ContentSource build() {
            return new ContentSource(this.contentType, this.url, this.title, this.locale, this.additionalProperties);
        }
    }
}

