/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.articles;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.articles.RawArticlesClient;
import com.intercom.api.resources.unstable.articles.requests.DeleteArticleRequest;
import com.intercom.api.resources.unstable.articles.requests.RetrieveArticleRequest;
import com.intercom.api.resources.unstable.articles.requests.SearchArticlesRequest;
import com.intercom.api.resources.unstable.articles.types.Article;
import com.intercom.api.resources.unstable.articles.types.ArticleSearchResponse;
import com.intercom.api.resources.unstable.types.ArticleList;
import com.intercom.api.resources.unstable.types.DeletedArticleObject;

public class ArticlesClient {
    protected final ClientOptions clientOptions;
    private final RawArticlesClient rawClient;

    public ArticlesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawArticlesClient(clientOptions);
    }

    public RawArticlesClient withRawResponse() {
        return this.rawClient;
    }

    public ArticleList listArticles() {
        return this.rawClient.listArticles().body();
    }

    public ArticleList listArticles(RequestOptions requestOptions) {
        return this.rawClient.listArticles(requestOptions).body();
    }

    public Article createArticle(Object request) {
        return this.rawClient.createArticle(request).body();
    }

    public Article createArticle(Object request, RequestOptions requestOptions) {
        return this.rawClient.createArticle(request, requestOptions).body();
    }

    public Article retrieveArticle(RetrieveArticleRequest request) {
        return this.rawClient.retrieveArticle(request).body();
    }

    public Article retrieveArticle(RetrieveArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveArticle(request, requestOptions).body();
    }

    public DeletedArticleObject deleteArticle(DeleteArticleRequest request) {
        return this.rawClient.deleteArticle(request).body();
    }

    public DeletedArticleObject deleteArticle(DeleteArticleRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteArticle(request, requestOptions).body();
    }

    public ArticleSearchResponse searchArticles() {
        return this.rawClient.searchArticles().body();
    }

    public ArticleSearchResponse searchArticles(SearchArticlesRequest request) {
        return this.rawClient.searchArticles(request).body();
    }

    public ArticleSearchResponse searchArticles(SearchArticlesRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchArticles(request, requestOptions).body();
    }
}

