/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.articles.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SearchArticlesRequest {
    private final Optional<String> phrase;
    private final Optional<String> state;
    private final Optional<Integer> helpCenterId;
    private final Optional<Boolean> highlight;
    private final Map<String, Object> additionalProperties;

    private SearchArticlesRequest(Optional<String> phrase, Optional<String> state, Optional<Integer> helpCenterId, Optional<Boolean> highlight, Map<String, Object> additionalProperties) {
        this.phrase = phrase;
        this.state = state;
        this.helpCenterId = helpCenterId;
        this.highlight = highlight;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="phrase")
    public Optional<String> getPhrase() {
        return this.phrase;
    }

    @JsonProperty(value="state")
    public Optional<String> getState() {
        return this.state;
    }

    @JsonProperty(value="help_center_id")
    public Optional<Integer> getHelpCenterId() {
        return this.helpCenterId;
    }

    @JsonProperty(value="highlight")
    public Optional<Boolean> getHighlight() {
        return this.highlight;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SearchArticlesRequest && this.equalTo((SearchArticlesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchArticlesRequest other) {
        return this.phrase.equals(other.phrase) && this.state.equals(other.state) && this.helpCenterId.equals(other.helpCenterId) && this.highlight.equals(other.highlight);
    }

    public int hashCode() {
        return Objects.hash(this.phrase, this.state, this.helpCenterId, this.highlight);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> phrase = Optional.empty();
        private Optional<String> state = Optional.empty();
        private Optional<Integer> helpCenterId = Optional.empty();
        private Optional<Boolean> highlight = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SearchArticlesRequest other) {
            this.phrase(other.getPhrase());
            this.state(other.getState());
            this.helpCenterId(other.getHelpCenterId());
            this.highlight(other.getHighlight());
            return this;
        }

        @JsonSetter(value="phrase", nulls=Nulls.SKIP)
        public Builder phrase(Optional<String> phrase) {
            this.phrase = phrase;
            return this;
        }

        public Builder phrase(String phrase) {
            this.phrase = Optional.ofNullable(phrase);
            return this;
        }

        @JsonSetter(value="state", nulls=Nulls.SKIP)
        public Builder state(Optional<String> state) {
            this.state = state;
            return this;
        }

        public Builder state(String state) {
            this.state = Optional.ofNullable(state);
            return this;
        }

        @JsonSetter(value="help_center_id", nulls=Nulls.SKIP)
        public Builder helpCenterId(Optional<Integer> helpCenterId) {
            this.helpCenterId = helpCenterId;
            return this;
        }

        public Builder helpCenterId(Integer helpCenterId) {
            this.helpCenterId = Optional.ofNullable(helpCenterId);
            return this;
        }

        @JsonSetter(value="highlight", nulls=Nulls.SKIP)
        public Builder highlight(Optional<Boolean> highlight) {
            this.highlight = highlight;
            return this;
        }

        public Builder highlight(Boolean highlight) {
            this.highlight = Optional.ofNullable(highlight);
            return this;
        }

        public SearchArticlesRequest build() {
            return new SearchArticlesRequest(this.phrase, this.state, this.helpCenterId, this.highlight, this.additionalProperties);
        }
    }
}

