/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.conversations;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.resources.unstable.conversations.RawConversationsClient;
import com.intercom.api.resources.unstable.conversations.requests.AttachContactToConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ConvertConversationToTicketRequest;
import com.intercom.api.resources.unstable.conversations.requests.CreateConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.DeleteConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.DetachContactFromConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ListConversationsRequest;
import com.intercom.api.resources.unstable.conversations.requests.ManageConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.ReplyConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.RetrieveConversationRequest;
import com.intercom.api.resources.unstable.conversations.requests.UpdateConversationRequest;
import com.intercom.api.resources.unstable.conversations.types.Conversation;
import com.intercom.api.resources.unstable.messages.types.Message;
import com.intercom.api.resources.unstable.tickets.types.Ticket;
import com.intercom.api.resources.unstable.types.ConversationDeleted;
import com.intercom.api.resources.unstable.types.ConversationList;
import com.intercom.api.resources.unstable.types.RedactConversationRequest;
import com.intercom.api.resources.unstable.types.SearchRequest;
import java.util.Optional;

public class ConversationsClient {
    protected final ClientOptions clientOptions;
    private final RawConversationsClient rawClient;

    public ConversationsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawConversationsClient(clientOptions);
    }

    public RawConversationsClient withRawResponse() {
        return this.rawClient;
    }

    public ConversationList listConversations() {
        return this.rawClient.listConversations().body();
    }

    public ConversationList listConversations(ListConversationsRequest request) {
        return this.rawClient.listConversations(request).body();
    }

    public ConversationList listConversations(ListConversationsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listConversations(request, requestOptions).body();
    }

    public Message createConversation(CreateConversationRequest request) {
        return this.rawClient.createConversation(request).body();
    }

    public Message createConversation(CreateConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.createConversation(request, requestOptions).body();
    }

    public Conversation retrieveConversation(RetrieveConversationRequest request) {
        return this.rawClient.retrieveConversation(request).body();
    }

    public Conversation retrieveConversation(RetrieveConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveConversation(request, requestOptions).body();
    }

    public Conversation updateConversation(UpdateConversationRequest request) {
        return this.rawClient.updateConversation(request).body();
    }

    public Conversation updateConversation(UpdateConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateConversation(request, requestOptions).body();
    }

    public ConversationDeleted deleteConversation(DeleteConversationRequest request) {
        return this.rawClient.deleteConversation(request).body();
    }

    public ConversationDeleted deleteConversation(DeleteConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteConversation(request, requestOptions).body();
    }

    public ConversationList searchConversations(SearchRequest request) {
        return this.rawClient.searchConversations(request).body();
    }

    public ConversationList searchConversations(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchConversations(request, requestOptions).body();
    }

    public Conversation replyConversation(ReplyConversationRequest request) {
        return this.rawClient.replyConversation(request).body();
    }

    public Conversation replyConversation(ReplyConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.replyConversation(request, requestOptions).body();
    }

    public Conversation manageConversation(ManageConversationRequest request) {
        return this.rawClient.manageConversation(request).body();
    }

    public Conversation manageConversation(ManageConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.manageConversation(request, requestOptions).body();
    }

    public Conversation attachContactToConversation(AttachContactToConversationRequest request) {
        return this.rawClient.attachContactToConversation(request).body();
    }

    public Conversation attachContactToConversation(AttachContactToConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachContactToConversation(request, requestOptions).body();
    }

    public Conversation detachContactFromConversation(DetachContactFromConversationRequest request) {
        return this.rawClient.detachContactFromConversation(request).body();
    }

    public Conversation detachContactFromConversation(DetachContactFromConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachContactFromConversation(request, requestOptions).body();
    }

    public Conversation redactConversation(RedactConversationRequest request) {
        return this.rawClient.redactConversation(request).body();
    }

    public Conversation redactConversation(RedactConversationRequest request, RequestOptions requestOptions) {
        return this.rawClient.redactConversation(request, requestOptions).body();
    }

    public Optional<Ticket> convertConversationToTicket(ConvertConversationToTicketRequest request) {
        return this.rawClient.convertConversationToTicket(request).body();
    }

    public Optional<Ticket> convertConversationToTicket(ConvertConversationToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.convertConversationToTicket(request, requestOptions).body();
    }
}

