/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.customobjectinstances.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateOrUpdateCustomObjectInstanceRequest {
    private final String customObjectTypeIdentifier;
    private final Optional<String> externalId;
    private final Optional<Integer> externalCreatedAt;
    private final Optional<Integer> externalUpdatedAt;
    private final Optional<Map<String, Optional<String>>> customAttributes;
    private final Map<String, Object> additionalProperties;

    private CreateOrUpdateCustomObjectInstanceRequest(String customObjectTypeIdentifier, Optional<String> externalId, Optional<Integer> externalCreatedAt, Optional<Integer> externalUpdatedAt, Optional<Map<String, Optional<String>>> customAttributes, Map<String, Object> additionalProperties) {
        this.customObjectTypeIdentifier = customObjectTypeIdentifier;
        this.externalId = externalId;
        this.externalCreatedAt = externalCreatedAt;
        this.externalUpdatedAt = externalUpdatedAt;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="custom_object_type_identifier")
    public String getCustomObjectTypeIdentifier() {
        return this.customObjectTypeIdentifier;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="external_created_at")
    public Optional<Integer> getExternalCreatedAt() {
        return this.externalCreatedAt;
    }

    @JsonProperty(value="external_updated_at")
    public Optional<Integer> getExternalUpdatedAt() {
        return this.externalUpdatedAt;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, Optional<String>>> getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateOrUpdateCustomObjectInstanceRequest && this.equalTo((CreateOrUpdateCustomObjectInstanceRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrUpdateCustomObjectInstanceRequest other) {
        return this.customObjectTypeIdentifier.equals(other.customObjectTypeIdentifier) && this.externalId.equals(other.externalId) && this.externalCreatedAt.equals(other.externalCreatedAt) && this.externalUpdatedAt.equals(other.externalUpdatedAt) && this.customAttributes.equals(other.customAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.customObjectTypeIdentifier, this.externalId, this.externalCreatedAt, this.externalUpdatedAt, this.customAttributes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomObjectTypeIdentifierStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomObjectTypeIdentifierStage,
    _FinalStage {
        private String customObjectTypeIdentifier;
        private Optional<Map<String, Optional<String>>> customAttributes = Optional.empty();
        private Optional<Integer> externalUpdatedAt = Optional.empty();
        private Optional<Integer> externalCreatedAt = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateOrUpdateCustomObjectInstanceRequest other) {
            this.customObjectTypeIdentifier(other.getCustomObjectTypeIdentifier());
            this.externalId(other.getExternalId());
            this.externalCreatedAt(other.getExternalCreatedAt());
            this.externalUpdatedAt(other.getExternalUpdatedAt());
            this.customAttributes(other.getCustomAttributes());
            return this;
        }

        @Override
        @JsonSetter(value="custom_object_type_identifier")
        public _FinalStage customObjectTypeIdentifier(@NotNull String customObjectTypeIdentifier) {
            this.customObjectTypeIdentifier = Objects.requireNonNull(customObjectTypeIdentifier, "customObjectTypeIdentifier must not be null");
            return this;
        }

        @Override
        public _FinalStage customAttributes(Map<String, Optional<String>> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Optional<String>>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @Override
        public _FinalStage externalUpdatedAt(Integer externalUpdatedAt) {
            this.externalUpdatedAt = Optional.ofNullable(externalUpdatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="external_updated_at", nulls=Nulls.SKIP)
        public _FinalStage externalUpdatedAt(Optional<Integer> externalUpdatedAt) {
            this.externalUpdatedAt = externalUpdatedAt;
            return this;
        }

        @Override
        public _FinalStage externalCreatedAt(Integer externalCreatedAt) {
            this.externalCreatedAt = Optional.ofNullable(externalCreatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="external_created_at", nulls=Nulls.SKIP)
        public _FinalStage externalCreatedAt(Optional<Integer> externalCreatedAt) {
            this.externalCreatedAt = externalCreatedAt;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public CreateOrUpdateCustomObjectInstanceRequest build() {
            return new CreateOrUpdateCustomObjectInstanceRequest(this.customObjectTypeIdentifier, this.externalId, this.externalCreatedAt, this.externalUpdatedAt, this.customAttributes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateOrUpdateCustomObjectInstanceRequest build();

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);

        public _FinalStage externalCreatedAt(Optional<Integer> var1);

        public _FinalStage externalCreatedAt(Integer var1);

        public _FinalStage externalUpdatedAt(Optional<Integer> var1);

        public _FinalStage externalUpdatedAt(Integer var1);

        public _FinalStage customAttributes(Optional<Map<String, Optional<String>>> var1);

        public _FinalStage customAttributes(Map<String, Optional<String>> var1);
    }

    public static interface CustomObjectTypeIdentifierStage {
        public _FinalStage customObjectTypeIdentifier(@NotNull String var1);

        public Builder from(CreateOrUpdateCustomObjectInstanceRequest var1);
    }
}

