/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataevents.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.dataevents.types.LisDataEventsRequestFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LisDataEventsRequest {
    private final LisDataEventsRequestFilter filter;
    private final String type;
    private final Optional<Boolean> summary;
    private final Map<String, Object> additionalProperties;

    private LisDataEventsRequest(LisDataEventsRequestFilter filter, String type, Optional<Boolean> summary, Map<String, Object> additionalProperties) {
        this.filter = filter;
        this.type = type;
        this.summary = summary;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="filter")
    public LisDataEventsRequestFilter getFilter() {
        return this.filter;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="summary")
    public Optional<Boolean> getSummary() {
        return this.summary;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LisDataEventsRequest && this.equalTo((LisDataEventsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LisDataEventsRequest other) {
        return this.filter.equals(other.filter) && this.type.equals(other.type) && this.summary.equals(other.summary);
    }

    public int hashCode() {
        return Objects.hash(this.filter, this.type, this.summary);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FilterStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FilterStage,
    TypeStage,
    _FinalStage {
        private LisDataEventsRequestFilter filter;
        private String type;
        private Optional<Boolean> summary = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LisDataEventsRequest other) {
            this.filter(other.getFilter());
            this.type(other.getType());
            this.summary(other.getSummary());
            return this;
        }

        @Override
        @JsonSetter(value="filter")
        public TypeStage filter(@NotNull LisDataEventsRequestFilter filter) {
            this.filter = Objects.requireNonNull(filter, "filter must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage summary(Boolean summary) {
            this.summary = Optional.ofNullable(summary);
            return this;
        }

        @Override
        @JsonSetter(value="summary", nulls=Nulls.SKIP)
        public _FinalStage summary(Optional<Boolean> summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public LisDataEventsRequest build() {
            return new LisDataEventsRequest(this.filter, this.type, this.summary, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LisDataEventsRequest build();

        public _FinalStage summary(Optional<Boolean> var1);

        public _FinalStage summary(Boolean var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull String var1);
    }

    public static interface FilterStage {
        public TypeStage filter(@NotNull LisDataEventsRequestFilter var1);

        public Builder from(LisDataEventsRequest var1);
    }
}

