/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.dataevents.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using=Deserializer.class)
public final class LisDataEventsRequestFilter {
    private final Object value;
    private final int type;

    private LisDataEventsRequestFilter(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((UserId)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((IntercomUserId)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((Email)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LisDataEventsRequestFilter && this.equalTo((LisDataEventsRequestFilter)other);
    }

    private boolean equalTo(LisDataEventsRequestFilter other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static LisDataEventsRequestFilter of(UserId value) {
        return new LisDataEventsRequestFilter(value, 0);
    }

    public static LisDataEventsRequestFilter of(IntercomUserId value) {
        return new LisDataEventsRequestFilter(value, 1);
    }

    public static LisDataEventsRequestFilter of(Email value) {
        return new LisDataEventsRequestFilter(value, 2);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class UserId {
        private final String userId;
        private final Map<String, Object> additionalProperties;

        private UserId(String userId, Map<String, Object> additionalProperties) {
            this.userId = userId;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="user_id")
        public String getUserId() {
            return this.userId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof UserId && this.equalTo((UserId)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(UserId other) {
            return this.userId.equals(other.userId);
        }

        public int hashCode() {
            return Objects.hash(this.userId);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static UserIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements UserIdStage,
        _FinalStage {
            private String userId;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(UserId other) {
                this.userId(other.getUserId());
                return this;
            }

            @Override
            @JsonSetter(value="user_id")
            public _FinalStage userId(@NotNull String userId) {
                this.userId = Objects.requireNonNull(userId, "userId must not be null");
                return this;
            }

            @Override
            public UserId build() {
                return new UserId(this.userId, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public UserId build();
        }

        public static interface UserIdStage {
            public _FinalStage userId(@NotNull String var1);

            public Builder from(UserId var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Email {
        private final String email;
        private final Map<String, Object> additionalProperties;

        private Email(String email, Map<String, Object> additionalProperties) {
            this.email = email;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="email")
        public String getEmail() {
            return this.email;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Email && this.equalTo((Email)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Email other) {
            return this.email.equals(other.email);
        }

        public int hashCode() {
            return Objects.hash(this.email);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static EmailStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements EmailStage,
        _FinalStage {
            private String email;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(Email other) {
                this.email(other.getEmail());
                return this;
            }

            @Override
            @JsonSetter(value="email")
            public _FinalStage email(@NotNull String email) {
                this.email = Objects.requireNonNull(email, "email must not be null");
                return this;
            }

            @Override
            public Email build() {
                return new Email(this.email, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public Email build();
        }

        public static interface EmailStage {
            public _FinalStage email(@NotNull String var1);

            public Builder from(Email var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class IntercomUserId {
        private final String intercomUserId;
        private final Map<String, Object> additionalProperties;

        private IntercomUserId(String intercomUserId, Map<String, Object> additionalProperties) {
            this.intercomUserId = intercomUserId;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="intercom_user_id")
        public String getIntercomUserId() {
            return this.intercomUserId;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof IntercomUserId && this.equalTo((IntercomUserId)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(IntercomUserId other) {
            return this.intercomUserId.equals(other.intercomUserId);
        }

        public int hashCode() {
            return Objects.hash(this.intercomUserId);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IntercomUserIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements IntercomUserIdStage,
        _FinalStage {
            private String intercomUserId;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(IntercomUserId other) {
                this.intercomUserId(other.getIntercomUserId());
                return this;
            }

            @Override
            @JsonSetter(value="intercom_user_id")
            public _FinalStage intercomUserId(@NotNull String intercomUserId) {
                this.intercomUserId = Objects.requireNonNull(intercomUserId, "intercomUserId must not be null");
                return this;
            }

            @Override
            public IntercomUserId build() {
                return new IntercomUserId(this.intercomUserId, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public IntercomUserId build();
        }

        public static interface IntercomUserIdStage {
            public _FinalStage intercomUserId(@NotNull String var1);

            public Builder from(IntercomUserId var1);
        }
    }

    static final class Deserializer
    extends StdDeserializer<LisDataEventsRequestFilter> {
        Deserializer() {
            super(LisDataEventsRequestFilter.class);
        }

        public LisDataEventsRequestFilter deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return LisDataEventsRequestFilter.of((UserId)ObjectMappers.JSON_MAPPER.convertValue(value, UserId.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return LisDataEventsRequestFilter.of((IntercomUserId)ObjectMappers.JSON_MAPPER.convertValue(value, IntercomUserId.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return LisDataEventsRequestFilter.of((Email)ObjectMappers.JSON_MAPPER.convertValue(value, Email.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(UserId var1);

        public T visit(IntercomUserId var1);

        public T visit(Email var1);
    }
}

