/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.ContactReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationContacts {
    private final Optional<String> type;
    private final Optional<List<ContactReference>> contacts;
    private final Map<String, Object> additionalProperties;

    private ConversationContacts(Optional<String> type, Optional<List<ContactReference>> contacts, Map<String, Object> additionalProperties) {
        this.type = type;
        this.contacts = contacts;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Optional<String> getType() {
        return this.type;
    }

    @JsonProperty(value="contacts")
    public Optional<List<ContactReference>> getContacts() {
        return this.contacts;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationContacts && this.equalTo((ConversationContacts)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationContacts other) {
        return this.type.equals(other.type) && this.contacts.equals(other.contacts);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.contacts);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();
        private Optional<List<ContactReference>> contacts = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ConversationContacts other) {
            this.type(other.getType());
            this.contacts(other.getContacts());
            return this;
        }

        @JsonSetter(value="type", nulls=Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        @JsonSetter(value="contacts", nulls=Nulls.SKIP)
        public Builder contacts(Optional<List<ContactReference>> contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder contacts(List<ContactReference> contacts) {
            this.contacts = Optional.ofNullable(contacts);
            return this;
        }

        public ConversationContacts build() {
            return new ConversationContacts(this.type, this.contacts, this.additionalProperties);
        }
    }
}

