/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DataEventSummaryItem {
    private final Optional<String> name;
    private final Optional<String> first;
    private final Optional<String> last;
    private final Optional<Integer> count;
    private final Optional<String> description;
    private final Map<String, Object> additionalProperties;

    private DataEventSummaryItem(Optional<String> name, Optional<String> first, Optional<String> last, Optional<Integer> count, Optional<String> description, Map<String, Object> additionalProperties) {
        this.name = name;
        this.first = first;
        this.last = last;
        this.count = count;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="first")
    public Optional<String> getFirst() {
        return this.first;
    }

    @JsonProperty(value="last")
    public Optional<String> getLast() {
        return this.last;
    }

    @JsonProperty(value="count")
    public Optional<Integer> getCount() {
        return this.count;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DataEventSummaryItem && this.equalTo((DataEventSummaryItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventSummaryItem other) {
        return this.name.equals(other.name) && this.first.equals(other.first) && this.last.equals(other.last) && this.count.equals(other.count) && this.description.equals(other.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.first, this.last, this.count, this.description);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> name = Optional.empty();
        private Optional<String> first = Optional.empty();
        private Optional<String> last = Optional.empty();
        private Optional<Integer> count = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(DataEventSummaryItem other) {
            this.name(other.getName());
            this.first(other.getFirst());
            this.last(other.getLast());
            this.count(other.getCount());
            this.description(other.getDescription());
            return this;
        }

        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value="first", nulls=Nulls.SKIP)
        public Builder first(Optional<String> first) {
            this.first = first;
            return this;
        }

        public Builder first(String first) {
            this.first = Optional.ofNullable(first);
            return this;
        }

        @JsonSetter(value="last", nulls=Nulls.SKIP)
        public Builder last(Optional<String> last) {
            this.last = last;
            return this;
        }

        public Builder last(String last) {
            this.last = Optional.ofNullable(last);
            return this;
        }

        @JsonSetter(value="count", nulls=Nulls.SKIP)
        public Builder count(Optional<Integer> count) {
            this.count = count;
            return this;
        }

        public Builder count(Integer count) {
            this.count = Optional.ofNullable(count);
            return this;
        }

        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        public DataEventSummaryItem build() {
            return new DataEventSummaryItem(this.name, this.first, this.last, this.count, this.description, this.additionalProperties);
        }
    }
}

