/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.unstable.visitors.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConvertVisitorRequest {
    private final String type;
    private final Object user;
    private final Object visitor;
    private final Map<String, Object> additionalProperties;

    private ConvertVisitorRequest(String type, Object user, Object visitor, Map<String, Object> additionalProperties) {
        this.type = type;
        this.user = user;
        this.visitor = visitor;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="user")
    public Object getUser() {
        return this.user;
    }

    @JsonProperty(value="visitor")
    public Object getVisitor() {
        return this.visitor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConvertVisitorRequest && this.equalTo((ConvertVisitorRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConvertVisitorRequest other) {
        return this.type.equals(other.type) && this.user.equals(other.user) && this.visitor.equals(other.visitor);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.user, this.visitor);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    UserStage,
    VisitorStage,
    _FinalStage {
        private String type;
        private Object user;
        private Object visitor;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConvertVisitorRequest other) {
            this.type(other.getType());
            this.user(other.getUser());
            this.visitor(other.getVisitor());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public UserStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user")
        public VisitorStage user(Object user) {
            this.user = user;
            return this;
        }

        @Override
        @JsonSetter(value="visitor")
        public _FinalStage visitor(Object visitor) {
            this.visitor = visitor;
            return this;
        }

        @Override
        public ConvertVisitorRequest build() {
            return new ConvertVisitorRequest(this.type, this.user, this.visitor, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConvertVisitorRequest build();
    }

    public static interface VisitorStage {
        public _FinalStage visitor(Object var1);
    }

    public static interface UserStage {
        public VisitorStage user(Object var1);
    }

    public static interface TypeStage {
        public UserStage type(@NotNull String var1);

        public Builder from(ConvertVisitorRequest var1);
    }
}

