/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ActivityLogMetadata {
    private final Optional<String> signInMethod;
    private final Optional<String> externalId;
    private final Optional<Boolean> awayMode;
    private final Optional<String> awayStatusReason;
    private final Optional<Boolean> reassignConversations;
    private final Optional<String> source;
    private final Optional<String> autoChanged;
    private final Optional<Integer> updateBy;
    private final Optional<String> updateByName;
    private final Map<String, Object> additionalProperties;

    private ActivityLogMetadata(Optional<String> signInMethod, Optional<String> externalId, Optional<Boolean> awayMode, Optional<String> awayStatusReason, Optional<Boolean> reassignConversations, Optional<String> source, Optional<String> autoChanged, Optional<Integer> updateBy, Optional<String> updateByName, Map<String, Object> additionalProperties) {
        this.signInMethod = signInMethod;
        this.externalId = externalId;
        this.awayMode = awayMode;
        this.awayStatusReason = awayStatusReason;
        this.reassignConversations = reassignConversations;
        this.source = source;
        this.autoChanged = autoChanged;
        this.updateBy = updateBy;
        this.updateByName = updateByName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="sign_in_method")
    public Optional<String> getSignInMethod() {
        return this.signInMethod;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="away_mode")
    public Optional<Boolean> getAwayMode() {
        return this.awayMode;
    }

    @JsonProperty(value="away_status_reason")
    public Optional<String> getAwayStatusReason() {
        return this.awayStatusReason;
    }

    @JsonProperty(value="reassign_conversations")
    public Optional<Boolean> getReassignConversations() {
        return this.reassignConversations;
    }

    @JsonProperty(value="source")
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty(value="auto_changed")
    public Optional<String> getAutoChanged() {
        return this.autoChanged;
    }

    @JsonProperty(value="update_by")
    public Optional<Integer> getUpdateBy() {
        return this.updateBy;
    }

    @JsonProperty(value="update_by_name")
    public Optional<String> getUpdateByName() {
        return this.updateByName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ActivityLogMetadata && this.equalTo((ActivityLogMetadata)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ActivityLogMetadata other) {
        return this.signInMethod.equals(other.signInMethod) && this.externalId.equals(other.externalId) && this.awayMode.equals(other.awayMode) && this.awayStatusReason.equals(other.awayStatusReason) && this.reassignConversations.equals(other.reassignConversations) && this.source.equals(other.source) && this.autoChanged.equals(other.autoChanged) && this.updateBy.equals(other.updateBy) && this.updateByName.equals(other.updateByName);
    }

    public int hashCode() {
        return Objects.hash(this.signInMethod, this.externalId, this.awayMode, this.awayStatusReason, this.reassignConversations, this.source, this.autoChanged, this.updateBy, this.updateByName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> signInMethod = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<Boolean> awayMode = Optional.empty();
        private Optional<String> awayStatusReason = Optional.empty();
        private Optional<Boolean> reassignConversations = Optional.empty();
        private Optional<String> source = Optional.empty();
        private Optional<String> autoChanged = Optional.empty();
        private Optional<Integer> updateBy = Optional.empty();
        private Optional<String> updateByName = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ActivityLogMetadata other) {
            this.signInMethod(other.getSignInMethod());
            this.externalId(other.getExternalId());
            this.awayMode(other.getAwayMode());
            this.awayStatusReason(other.getAwayStatusReason());
            this.reassignConversations(other.getReassignConversations());
            this.source(other.getSource());
            this.autoChanged(other.getAutoChanged());
            this.updateBy(other.getUpdateBy());
            this.updateByName(other.getUpdateByName());
            return this;
        }

        @JsonSetter(value="sign_in_method", nulls=Nulls.SKIP)
        public Builder signInMethod(Optional<String> signInMethod) {
            this.signInMethod = signInMethod;
            return this;
        }

        public Builder signInMethod(String signInMethod) {
            this.signInMethod = Optional.ofNullable(signInMethod);
            return this;
        }

        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public Builder externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @JsonSetter(value="away_mode", nulls=Nulls.SKIP)
        public Builder awayMode(Optional<Boolean> awayMode) {
            this.awayMode = awayMode;
            return this;
        }

        public Builder awayMode(Boolean awayMode) {
            this.awayMode = Optional.ofNullable(awayMode);
            return this;
        }

        @JsonSetter(value="away_status_reason", nulls=Nulls.SKIP)
        public Builder awayStatusReason(Optional<String> awayStatusReason) {
            this.awayStatusReason = awayStatusReason;
            return this;
        }

        public Builder awayStatusReason(String awayStatusReason) {
            this.awayStatusReason = Optional.ofNullable(awayStatusReason);
            return this;
        }

        @JsonSetter(value="reassign_conversations", nulls=Nulls.SKIP)
        public Builder reassignConversations(Optional<Boolean> reassignConversations) {
            this.reassignConversations = reassignConversations;
            return this;
        }

        public Builder reassignConversations(Boolean reassignConversations) {
            this.reassignConversations = Optional.ofNullable(reassignConversations);
            return this;
        }

        @JsonSetter(value="source", nulls=Nulls.SKIP)
        public Builder source(Optional<String> source) {
            this.source = source;
            return this;
        }

        public Builder source(String source) {
            this.source = Optional.ofNullable(source);
            return this;
        }

        @JsonSetter(value="auto_changed", nulls=Nulls.SKIP)
        public Builder autoChanged(Optional<String> autoChanged) {
            this.autoChanged = autoChanged;
            return this;
        }

        public Builder autoChanged(String autoChanged) {
            this.autoChanged = Optional.ofNullable(autoChanged);
            return this;
        }

        @JsonSetter(value="update_by", nulls=Nulls.SKIP)
        public Builder updateBy(Optional<Integer> updateBy) {
            this.updateBy = updateBy;
            return this;
        }

        public Builder updateBy(Integer updateBy) {
            this.updateBy = Optional.ofNullable(updateBy);
            return this;
        }

        @JsonSetter(value="update_by_name", nulls=Nulls.SKIP)
        public Builder updateByName(Optional<String> updateByName) {
            this.updateByName = updateByName;
            return this;
        }

        public Builder updateByName(String updateByName) {
            this.updateByName = Optional.ofNullable(updateByName);
            return this;
        }

        public ActivityLogMetadata build() {
            return new ActivityLogMetadata(this.signInMethod, this.externalId, this.awayMode, this.awayStatusReason, this.reassignConversations, this.source, this.autoChanged, this.updateBy, this.updateByName, this.additionalProperties);
        }
    }
}

