/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class App {
    private final String type;
    private final String idCode;
    private final String name;
    private final String region;
    private final String timezone;
    private final int createdAt;
    private final boolean identityVerification;
    private final Map<String, Object> additionalProperties;

    private App(String type, String idCode, String name, String region, String timezone, int createdAt, boolean identityVerification, Map<String, Object> additionalProperties) {
        this.type = type;
        this.idCode = idCode;
        this.name = name;
        this.region = region;
        this.timezone = timezone;
        this.createdAt = createdAt;
        this.identityVerification = identityVerification;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="id_code")
    public String getIdCode() {
        return this.idCode;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="region")
    public String getRegion() {
        return this.region;
    }

    @JsonProperty(value="timezone")
    public String getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="identity_verification")
    public boolean getIdentityVerification() {
        return this.identityVerification;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof App && this.equalTo((App)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(App other) {
        return this.type.equals(other.type) && this.idCode.equals(other.idCode) && this.name.equals(other.name) && this.region.equals(other.region) && this.timezone.equals(other.timezone) && this.createdAt == other.createdAt && this.identityVerification == other.identityVerification;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.idCode, this.name, this.region, this.timezone, this.createdAt, this.identityVerification);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    IdCodeStage,
    NameStage,
    RegionStage,
    TimezoneStage,
    CreatedAtStage,
    IdentityVerificationStage,
    _FinalStage {
        private String type;
        private String idCode;
        private String name;
        private String region;
        private String timezone;
        private int createdAt;
        private boolean identityVerification;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(App other) {
            this.type(other.getType());
            this.idCode(other.getIdCode());
            this.name(other.getName());
            this.region(other.getRegion());
            this.timezone(other.getTimezone());
            this.createdAt(other.getCreatedAt());
            this.identityVerification(other.getIdentityVerification());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdCodeStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id_code")
        public NameStage idCode(@NotNull String idCode) {
            this.idCode = Objects.requireNonNull(idCode, "idCode must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public RegionStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="region")
        public TimezoneStage region(@NotNull String region) {
            this.region = Objects.requireNonNull(region, "region must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="timezone")
        public CreatedAtStage timezone(@NotNull String timezone) {
            this.timezone = Objects.requireNonNull(timezone, "timezone must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IdentityVerificationStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="identity_verification")
        public _FinalStage identityVerification(boolean identityVerification) {
            this.identityVerification = identityVerification;
            return this;
        }

        @Override
        public App build() {
            return new App(this.type, this.idCode, this.name, this.region, this.timezone, this.createdAt, this.identityVerification, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public App build();
    }

    public static interface IdentityVerificationStage {
        public _FinalStage identityVerification(boolean var1);
    }

    public static interface CreatedAtStage {
        public IdentityVerificationStage createdAt(int var1);
    }

    public static interface TimezoneStage {
        public CreatedAtStage timezone(@NotNull String var1);
    }

    public static interface RegionStage {
        public TimezoneStage region(@NotNull String var1);
    }

    public static interface NameStage {
        public RegionStage name(@NotNull String var1);
    }

    public static interface IdCodeStage {
        public NameStage idCode(@NotNull String var1);
    }

    public static interface TypeStage {
        public IdCodeStage type(@NotNull String var1);

        public Builder from(App var1);
    }
}

