/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ActionComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ButtonComponent {
    private final String id;
    private final String label;
    private final ActionComponent action;
    private final Optional<Style> style;
    private final Optional<Boolean> disabled;
    private final Map<String, Object> additionalProperties;

    private ButtonComponent(String id, String label, ActionComponent action, Optional<Style> style, Optional<Boolean> disabled, Map<String, Object> additionalProperties) {
        this.id = id;
        this.label = label;
        this.action = action;
        this.style = style;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="action")
    public ActionComponent getAction() {
        return this.action;
    }

    @JsonProperty(value="style")
    public Optional<Style> getStyle() {
        return this.style;
    }

    @JsonProperty(value="disabled")
    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ButtonComponent && this.equalTo((ButtonComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ButtonComponent other) {
        return this.id.equals(other.id) && this.label.equals(other.label) && this.action.equals(other.action) && this.style.equals(other.style) && this.disabled.equals(other.disabled);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.label, this.action, this.style, this.disabled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class Style {
        public static final Style SECONDARY = new Style(Value.SECONDARY, "secondary");
        public static final Style LINK = new Style(Value.LINK, "link");
        public static final Style PRIMARY = new Style(Value.PRIMARY, "primary");
        private final Value value;
        private final String string;

        Style(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Style && this.string.equals(((Style)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SECONDARY: {
                    return visitor.visitSecondary();
                }
                case LINK: {
                    return visitor.visitLink();
                }
                case PRIMARY: {
                    return visitor.visitPrimary();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Style valueOf(String value) {
            switch (value) {
                case "secondary": {
                    return SECONDARY;
                }
                case "link": {
                    return LINK;
                }
                case "primary": {
                    return PRIMARY;
                }
            }
            return new Style(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitPrimary();

            public T visitSecondary();

            public T visitLink();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            PRIMARY,
            SECONDARY,
            LINK,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    LabelStage,
    ActionStage,
    _FinalStage {
        private String id;
        private String label;
        private ActionComponent action;
        private Optional<Boolean> disabled = Optional.empty();
        private Optional<Style> style = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ButtonComponent other) {
            this.id(other.getId());
            this.label(other.getLabel());
            this.action(other.getAction());
            this.style(other.getStyle());
            this.disabled(other.getDisabled());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public LabelStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="label")
        public ActionStage label(@NotNull String label) {
            this.label = Objects.requireNonNull(label, "label must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="action")
        public _FinalStage action(@NotNull ActionComponent action) {
            this.action = Objects.requireNonNull(action, "action must not be null");
            return this;
        }

        @Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        @Override
        @JsonSetter(value="disabled", nulls=Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public _FinalStage style(Style style) {
            this.style = Optional.ofNullable(style);
            return this;
        }

        @Override
        @JsonSetter(value="style", nulls=Nulls.SKIP)
        public _FinalStage style(Optional<Style> style) {
            this.style = style;
            return this;
        }

        @Override
        public ButtonComponent build() {
            return new ButtonComponent(this.id, this.label, this.action, this.style, this.disabled, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ButtonComponent build();

        public _FinalStage style(Optional<Style> var1);

        public _FinalStage style(Style var1);

        public _FinalStage disabled(Optional<Boolean> var1);

        public _FinalStage disabled(Boolean var1);
    }

    public static interface ActionStage {
        public _FinalStage action(@NotNull ActionComponent var1);
    }

    public static interface LabelStage {
        public ActionStage label(@NotNull String var1);
    }

    public static interface IdStage {
        public LabelStage id(@NotNull String var1);

        public Builder from(ButtonComponent var1);
    }
}

