/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.CheckboxOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckboxComponent {
    private final String id;
    private final List<CheckboxOption> option;
    private final String label;
    private final Optional<List<String>> value;
    private final Optional<SaveState> saveState;
    private final Optional<Boolean> disabled;
    private final Map<String, Object> additionalProperties;

    private CheckboxComponent(String id, List<CheckboxOption> option, String label, Optional<List<String>> value, Optional<SaveState> saveState, Optional<Boolean> disabled, Map<String, Object> additionalProperties) {
        this.id = id;
        this.option = option;
        this.label = label;
        this.value = value;
        this.saveState = saveState;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="option")
    public List<CheckboxOption> getOption() {
        return this.option;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="value")
    public Optional<List<String>> getValue() {
        return this.value;
    }

    @JsonProperty(value="save_state")
    public Optional<SaveState> getSaveState() {
        return this.saveState;
    }

    @JsonProperty(value="disabled")
    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckboxComponent && this.equalTo((CheckboxComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckboxComponent other) {
        return this.id.equals(other.id) && this.option.equals(other.option) && this.label.equals(other.label) && this.value.equals(other.value) && this.saveState.equals(other.saveState) && this.disabled.equals(other.disabled);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.option, this.label, this.value, this.saveState, this.disabled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class SaveState {
        public static final SaveState SAVED = new SaveState(Value.SAVED, "saved");
        public static final SaveState UNSAVED = new SaveState(Value.UNSAVED, "unsaved");
        public static final SaveState FAILED = new SaveState(Value.FAILED, "failed");
        private final Value value;
        private final String string;

        SaveState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SaveState && this.string.equals(((SaveState)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SAVED: {
                    return visitor.visitSaved();
                }
                case UNSAVED: {
                    return visitor.visitUnsaved();
                }
                case FAILED: {
                    return visitor.visitFailed();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static SaveState valueOf(String value) {
            switch (value) {
                case "saved": {
                    return SAVED;
                }
                case "unsaved": {
                    return UNSAVED;
                }
                case "failed": {
                    return FAILED;
                }
            }
            return new SaveState(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitUnsaved();

            public T visitSaved();

            public T visitFailed();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            UNSAVED,
            SAVED,
            FAILED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    LabelStage,
    _FinalStage {
        private String id;
        private String label;
        private Optional<Boolean> disabled = Optional.empty();
        private Optional<SaveState> saveState = Optional.empty();
        private Optional<List<String>> value = Optional.empty();
        private List<CheckboxOption> option = new ArrayList<CheckboxOption>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CheckboxComponent other) {
            this.id(other.getId());
            this.option(other.getOption());
            this.label(other.getLabel());
            this.value(other.getValue());
            this.saveState(other.getSaveState());
            this.disabled(other.getDisabled());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public LabelStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="label")
        public _FinalStage label(@NotNull String label) {
            this.label = Objects.requireNonNull(label, "label must not be null");
            return this;
        }

        @Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        @Override
        @JsonSetter(value="disabled", nulls=Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public _FinalStage saveState(SaveState saveState) {
            this.saveState = Optional.ofNullable(saveState);
            return this;
        }

        @Override
        @JsonSetter(value="save_state", nulls=Nulls.SKIP)
        public _FinalStage saveState(Optional<SaveState> saveState) {
            this.saveState = saveState;
            return this;
        }

        @Override
        public _FinalStage value(List<String> value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public _FinalStage value(Optional<List<String>> value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage addAllOption(List<CheckboxOption> option) {
            this.option.addAll(option);
            return this;
        }

        @Override
        public _FinalStage addOption(CheckboxOption option) {
            this.option.add(option);
            return this;
        }

        @Override
        @JsonSetter(value="option", nulls=Nulls.SKIP)
        public _FinalStage option(List<CheckboxOption> option) {
            this.option.clear();
            this.option.addAll(option);
            return this;
        }

        @Override
        public CheckboxComponent build() {
            return new CheckboxComponent(this.id, this.option, this.label, this.value, this.saveState, this.disabled, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CheckboxComponent build();

        public _FinalStage option(List<CheckboxOption> var1);

        public _FinalStage addOption(CheckboxOption var1);

        public _FinalStage addAllOption(List<CheckboxOption> var1);

        public _FinalStage value(Optional<List<String>> var1);

        public _FinalStage value(List<String> var1);

        public _FinalStage saveState(Optional<SaveState> var1);

        public _FinalStage saveState(SaveState var1);

        public _FinalStage disabled(Optional<Boolean> var1);

        public _FinalStage disabled(Boolean var1);
    }

    public static interface LabelStage {
        public _FinalStage label(@NotNull String var1);
    }

    public static interface IdStage {
        public LabelStage id(@NotNull String var1);

        public Builder from(CheckboxComponent var1);
    }
}

