/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationFirstContactReply {
    private final int createdAt;
    private final String type;
    private final Optional<String> url;
    private final Map<String, Object> additionalProperties;

    private ConversationFirstContactReply(int createdAt, String type, Optional<String> url, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.type = type;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationFirstContactReply && this.equalTo((ConversationFirstContactReply)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationFirstContactReply other) {
        return this.createdAt == other.createdAt && this.type.equals(other.type) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.type, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    TypeStage,
    _FinalStage {
        private int createdAt;
        private String type;
        private Optional<String> url = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConversationFirstContactReply other) {
            this.createdAt(other.getCreatedAt());
            this.type(other.getType());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public TypeStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public ConversationFirstContactReply build() {
            return new ConversationFirstContactReply(this.createdAt, this.type, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConversationFirstContactReply build();

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public TypeStage createdAt(int var1);

        public Builder from(ConversationFirstContactReply var1);
    }
}

