/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ConversationPartAuthor;
import com.intercom.api.types.PartAttachment;
import com.intercom.api.types.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationPart {
    private final String id;
    private final String partType;
    private final Optional<String> body;
    private final int createdAt;
    private final Optional<Integer> updatedAt;
    private final int notifiedAt;
    private final Optional<Reference> assignedTo;
    private final ConversationPartAuthor author;
    private final Optional<List<PartAttachment>> attachments;
    private final Optional<String> externalId;
    private final boolean redacted;
    private final Map<String, Object> additionalProperties;

    private ConversationPart(String id, String partType, Optional<String> body, int createdAt, Optional<Integer> updatedAt, int notifiedAt, Optional<Reference> assignedTo, ConversationPartAuthor author, Optional<List<PartAttachment>> attachments, Optional<String> externalId, boolean redacted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.notifiedAt = notifiedAt;
        this.assignedTo = assignedTo;
        this.author = author;
        this.attachments = attachments;
        this.externalId = externalId;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "conversation_part";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="part_type")
    public String getPartType() {
        return this.partType;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="notified_at")
    public int getNotifiedAt() {
        return this.notifiedAt;
    }

    @JsonProperty(value="assigned_to")
    public Optional<Reference> getAssignedTo() {
        return this.assignedTo;
    }

    @JsonProperty(value="author")
    public ConversationPartAuthor getAuthor() {
        return this.author;
    }

    @JsonProperty(value="attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="redacted")
    public boolean getRedacted() {
        return this.redacted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationPart && this.equalTo((ConversationPart)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationPart other) {
        return this.id.equals(other.id) && this.partType.equals(other.partType) && this.body.equals(other.body) && this.createdAt == other.createdAt && this.updatedAt.equals(other.updatedAt) && this.notifiedAt == other.notifiedAt && this.assignedTo.equals(other.assignedTo) && this.author.equals(other.author) && this.attachments.equals(other.attachments) && this.externalId.equals(other.externalId) && this.redacted == other.redacted;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.notifiedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    PartTypeStage,
    CreatedAtStage,
    NotifiedAtStage,
    AuthorStage,
    RedactedStage,
    _FinalStage {
        private String id;
        private String partType;
        private int createdAt;
        private int notifiedAt;
        private ConversationPartAuthor author;
        private boolean redacted;
        private Optional<String> externalId = Optional.empty();
        private Optional<List<PartAttachment>> attachments = Optional.empty();
        private Optional<Reference> assignedTo = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConversationPart other) {
            this.id(other.getId());
            this.partType(other.getPartType());
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.notifiedAt(other.getNotifiedAt());
            this.assignedTo(other.getAssignedTo());
            this.author(other.getAuthor());
            this.attachments(other.getAttachments());
            this.externalId(other.getExternalId());
            this.redacted(other.getRedacted());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PartTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="part_type")
        public CreatedAtStage partType(@NotNull String partType) {
            this.partType = Objects.requireNonNull(partType, "partType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public NotifiedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        @JsonSetter(value="notified_at")
        public AuthorStage notifiedAt(int notifiedAt) {
            this.notifiedAt = notifiedAt;
            return this;
        }

        @Override
        @JsonSetter(value="author")
        public RedactedStage author(@NotNull ConversationPartAuthor author) {
            this.author = Objects.requireNonNull(author, "author must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="redacted")
        public _FinalStage redacted(boolean redacted) {
            this.redacted = redacted;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @Override
        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        @Override
        public _FinalStage assignedTo(Reference assignedTo) {
            this.assignedTo = Optional.ofNullable(assignedTo);
            return this;
        }

        @Override
        @JsonSetter(value="assigned_to", nulls=Nulls.SKIP)
        public _FinalStage assignedTo(Optional<Reference> assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public ConversationPart build() {
            return new ConversationPart(this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.notifiedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConversationPart build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);

        public _FinalStage assignedTo(Optional<Reference> var1);

        public _FinalStage assignedTo(Reference var1);

        public _FinalStage attachments(Optional<List<PartAttachment>> var1);

        public _FinalStage attachments(List<PartAttachment> var1);

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);
    }

    public static interface RedactedStage {
        public _FinalStage redacted(boolean var1);
    }

    public static interface AuthorStage {
        public RedactedStage author(@NotNull ConversationPartAuthor var1);
    }

    public static interface NotifiedAtStage {
        public AuthorStage notifiedAt(int var1);
    }

    public static interface CreatedAtStage {
        public NotifiedAtStage createdAt(int var1);
    }

    public static interface PartTypeStage {
        public CreatedAtStage partType(@NotNull String var1);
    }

    public static interface IdStage {
        public PartTypeStage id(@NotNull String var1);

        public Builder from(ConversationPart var1);
    }
}

