/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ConversationPartAuthor;
import com.intercom.api.types.PartAttachment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationSource {
    private final Type type;
    private final String id;
    private final String deliveredAs;
    private final String subject;
    private final Optional<String> body;
    private final ConversationPartAuthor author;
    private final Optional<List<PartAttachment>> attachments;
    private final Optional<String> url;
    private final boolean redacted;
    private final Map<String, Object> additionalProperties;

    private ConversationSource(Type type, String id, String deliveredAs, String subject, Optional<String> body, ConversationPartAuthor author, Optional<List<PartAttachment>> attachments, Optional<String> url, boolean redacted, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.deliveredAs = deliveredAs;
        this.subject = subject;
        this.body = body;
        this.author = author;
        this.attachments = attachments;
        this.url = url;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="delivered_as")
    public String getDeliveredAs() {
        return this.deliveredAs;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="author")
    public ConversationPartAuthor getAuthor() {
        return this.author;
    }

    @JsonProperty(value="attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="url")
    public Optional<String> getUrl() {
        return this.url;
    }

    @JsonProperty(value="redacted")
    public boolean getRedacted() {
        return this.redacted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationSource && this.equalTo((ConversationSource)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationSource other) {
        return this.type.equals(other.type) && this.id.equals(other.id) && this.deliveredAs.equals(other.deliveredAs) && this.subject.equals(other.subject) && this.body.equals(other.body) && this.author.equals(other.author) && this.attachments.equals(other.attachments) && this.url.equals(other.url) && this.redacted == other.redacted;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.id, this.deliveredAs, this.subject, this.body, this.author, this.attachments, this.url, this.redacted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public static final class Type {
        public static final Type EMAIL = new Type(Value.EMAIL, "email");
        public static final Type FACEBOOK = new Type(Value.FACEBOOK, "facebook");
        public static final Type INSTAGRAM = new Type(Value.INSTAGRAM, "instagram");
        public static final Type PHONE_CALL = new Type(Value.PHONE_CALL, "phone_call");
        public static final Type PUSH = new Type(Value.PUSH, "push");
        public static final Type WHATSAPP = new Type(Value.WHATSAPP, "whatsapp");
        public static final Type SMS = new Type(Value.SMS, "sms");
        public static final Type CONVERSATION = new Type(Value.CONVERSATION, "conversation");
        public static final Type TWITTER = new Type(Value.TWITTER, "twitter");
        public static final Type PHONE_SWITCH = new Type(Value.PHONE_SWITCH, "phone_switch");
        private final Value value;
        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Type && this.string.equals(((Type)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case EMAIL: {
                    return visitor.visitEmail();
                }
                case FACEBOOK: {
                    return visitor.visitFacebook();
                }
                case INSTAGRAM: {
                    return visitor.visitInstagram();
                }
                case PHONE_CALL: {
                    return visitor.visitPhoneCall();
                }
                case PUSH: {
                    return visitor.visitPush();
                }
                case WHATSAPP: {
                    return visitor.visitWhatsapp();
                }
                case SMS: {
                    return visitor.visitSms();
                }
                case CONVERSATION: {
                    return visitor.visitConversation();
                }
                case TWITTER: {
                    return visitor.visitTwitter();
                }
                case PHONE_SWITCH: {
                    return visitor.visitPhoneSwitch();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "email": {
                    return EMAIL;
                }
                case "facebook": {
                    return FACEBOOK;
                }
                case "instagram": {
                    return INSTAGRAM;
                }
                case "phone_call": {
                    return PHONE_CALL;
                }
                case "push": {
                    return PUSH;
                }
                case "whatsapp": {
                    return WHATSAPP;
                }
                case "sms": {
                    return SMS;
                }
                case "conversation": {
                    return CONVERSATION;
                }
                case "twitter": {
                    return TWITTER;
                }
                case "phone_switch": {
                    return PHONE_SWITCH;
                }
            }
            return new Type(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitConversation();

            public T visitEmail();

            public T visitFacebook();

            public T visitInstagram();

            public T visitPhoneCall();

            public T visitPhoneSwitch();

            public T visitPush();

            public T visitSms();

            public T visitTwitter();

            public T visitWhatsapp();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            CONVERSATION,
            EMAIL,
            FACEBOOK,
            INSTAGRAM,
            PHONE_CALL,
            PHONE_SWITCH,
            PUSH,
            SMS,
            TWITTER,
            WHATSAPP,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    IdStage,
    DeliveredAsStage,
    SubjectStage,
    AuthorStage,
    RedactedStage,
    _FinalStage {
        private Type type;
        private String id;
        private String deliveredAs;
        private String subject;
        private ConversationPartAuthor author;
        private boolean redacted;
        private Optional<String> url = Optional.empty();
        private Optional<List<PartAttachment>> attachments = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConversationSource other) {
            this.type(other.getType());
            this.id(other.getId());
            this.deliveredAs(other.getDeliveredAs());
            this.subject(other.getSubject());
            this.body(other.getBody());
            this.author(other.getAuthor());
            this.attachments(other.getAttachments());
            this.url(other.getUrl());
            this.redacted(other.getRedacted());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public IdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public DeliveredAsStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="delivered_as")
        public SubjectStage deliveredAs(@NotNull String deliveredAs) {
            this.deliveredAs = Objects.requireNonNull(deliveredAs, "deliveredAs must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="subject")
        public AuthorStage subject(@NotNull String subject) {
            this.subject = Objects.requireNonNull(subject, "subject must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="author")
        public RedactedStage author(@NotNull ConversationPartAuthor author) {
            this.author = Objects.requireNonNull(author, "author must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="redacted")
        public _FinalStage redacted(boolean redacted) {
            this.redacted = redacted;
            return this;
        }

        @Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @Override
        @JsonSetter(value="url", nulls=Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @Override
        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public ConversationSource build() {
            return new ConversationSource(this.type, this.id, this.deliveredAs, this.subject, this.body, this.author, this.attachments, this.url, this.redacted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConversationSource build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage attachments(Optional<List<PartAttachment>> var1);

        public _FinalStage attachments(List<PartAttachment> var1);

        public _FinalStage url(Optional<String> var1);

        public _FinalStage url(String var1);
    }

    public static interface RedactedStage {
        public _FinalStage redacted(boolean var1);
    }

    public static interface AuthorStage {
        public RedactedStage author(@NotNull ConversationPartAuthor var1);
    }

    public static interface SubjectStage {
        public AuthorStage subject(@NotNull String var1);
    }

    public static interface DeliveredAsStage {
        public SubjectStage deliveredAs(@NotNull String var1);
    }

    public static interface IdStage {
        public DeliveredAsStage id(@NotNull String var1);
    }

    public static interface TypeStage {
        public IdStage type(@NotNull Type var1);

        public Builder from(ConversationSource var1);
    }
}

