/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using=Deserializer.class)
public final class CreateDataEventRequest {
    private final Object value;
    private final int type;

    private CreateDataEventRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((WithId)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((WithUserId)this.value);
        }
        if (this.type == 2) {
            return visitor.visit((WithEmail)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateDataEventRequest && this.equalTo((CreateDataEventRequest)other);
    }

    private boolean equalTo(CreateDataEventRequest other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static CreateDataEventRequest of(WithId value) {
        return new CreateDataEventRequest(value, 0);
    }

    public static CreateDataEventRequest of(WithUserId value) {
        return new CreateDataEventRequest(value, 1);
    }

    public static CreateDataEventRequest of(WithEmail value) {
        return new CreateDataEventRequest(value, 2);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class WithId {
        private final String id;
        private final String eventName;
        private final int createdAt;
        private final Optional<Map<String, String>> metadata;
        private final Map<String, Object> additionalProperties;

        private WithId(String id, String eventName, int createdAt, Optional<Map<String, String>> metadata, Map<String, Object> additionalProperties) {
            this.id = id;
            this.eventName = eventName;
            this.createdAt = createdAt;
            this.metadata = metadata;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="id")
        public String getId() {
            return this.id;
        }

        @JsonProperty(value="event_name")
        public String getEventName() {
            return this.eventName;
        }

        @JsonProperty(value="created_at")
        public int getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="metadata")
        public Optional<Map<String, String>> getMetadata() {
            return this.metadata;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof WithId && this.equalTo((WithId)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithId other) {
            return this.id.equals(other.id) && this.eventName.equals(other.eventName) && this.createdAt == other.createdAt && this.metadata.equals(other.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.eventName, this.createdAt, this.metadata);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static IdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements IdStage,
        EventNameStage,
        CreatedAtStage,
        _FinalStage {
            private String id;
            private String eventName;
            private int createdAt;
            private Optional<Map<String, String>> metadata = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(WithId other) {
                this.id(other.getId());
                this.eventName(other.getEventName());
                this.createdAt(other.getCreatedAt());
                this.metadata(other.getMetadata());
                return this;
            }

            @Override
            @JsonSetter(value="id")
            public EventNameStage id(@NotNull String id) {
                this.id = Objects.requireNonNull(id, "id must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="event_name")
            public CreatedAtStage eventName(@NotNull String eventName) {
                this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="created_at")
            public _FinalStage createdAt(int createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Override
            public _FinalStage metadata(Map<String, String> metadata) {
                this.metadata = Optional.ofNullable(metadata);
                return this;
            }

            @Override
            @JsonSetter(value="metadata", nulls=Nulls.SKIP)
            public _FinalStage metadata(Optional<Map<String, String>> metadata) {
                this.metadata = metadata;
                return this;
            }

            @Override
            public WithId build() {
                return new WithId(this.id, this.eventName, this.createdAt, this.metadata, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public WithId build();

            public _FinalStage metadata(Optional<Map<String, String>> var1);

            public _FinalStage metadata(Map<String, String> var1);
        }

        public static interface CreatedAtStage {
            public _FinalStage createdAt(int var1);
        }

        public static interface EventNameStage {
            public CreatedAtStage eventName(@NotNull String var1);
        }

        public static interface IdStage {
            public EventNameStage id(@NotNull String var1);

            public Builder from(WithId var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class WithEmail {
        private final String email;
        private final String eventName;
        private final int createdAt;
        private final Optional<Map<String, String>> metadata;
        private final Map<String, Object> additionalProperties;

        private WithEmail(String email, String eventName, int createdAt, Optional<Map<String, String>> metadata, Map<String, Object> additionalProperties) {
            this.email = email;
            this.eventName = eventName;
            this.createdAt = createdAt;
            this.metadata = metadata;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="email")
        public String getEmail() {
            return this.email;
        }

        @JsonProperty(value="event_name")
        public String getEventName() {
            return this.eventName;
        }

        @JsonProperty(value="created_at")
        public int getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="metadata")
        public Optional<Map<String, String>> getMetadata() {
            return this.metadata;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof WithEmail && this.equalTo((WithEmail)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithEmail other) {
            return this.email.equals(other.email) && this.eventName.equals(other.eventName) && this.createdAt == other.createdAt && this.metadata.equals(other.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.email, this.eventName, this.createdAt, this.metadata);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static EmailStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements EmailStage,
        EventNameStage,
        CreatedAtStage,
        _FinalStage {
            private String email;
            private String eventName;
            private int createdAt;
            private Optional<Map<String, String>> metadata = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(WithEmail other) {
                this.email(other.getEmail());
                this.eventName(other.getEventName());
                this.createdAt(other.getCreatedAt());
                this.metadata(other.getMetadata());
                return this;
            }

            @Override
            @JsonSetter(value="email")
            public EventNameStage email(@NotNull String email) {
                this.email = Objects.requireNonNull(email, "email must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="event_name")
            public CreatedAtStage eventName(@NotNull String eventName) {
                this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="created_at")
            public _FinalStage createdAt(int createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Override
            public _FinalStage metadata(Map<String, String> metadata) {
                this.metadata = Optional.ofNullable(metadata);
                return this;
            }

            @Override
            @JsonSetter(value="metadata", nulls=Nulls.SKIP)
            public _FinalStage metadata(Optional<Map<String, String>> metadata) {
                this.metadata = metadata;
                return this;
            }

            @Override
            public WithEmail build() {
                return new WithEmail(this.email, this.eventName, this.createdAt, this.metadata, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public WithEmail build();

            public _FinalStage metadata(Optional<Map<String, String>> var1);

            public _FinalStage metadata(Map<String, String> var1);
        }

        public static interface CreatedAtStage {
            public _FinalStage createdAt(int var1);
        }

        public static interface EventNameStage {
            public CreatedAtStage eventName(@NotNull String var1);
        }

        public static interface EmailStage {
            public EventNameStage email(@NotNull String var1);

            public Builder from(WithEmail var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class WithUserId {
        private final String userId;
        private final String eventName;
        private final int createdAt;
        private final Optional<Map<String, String>> metadata;
        private final Map<String, Object> additionalProperties;

        private WithUserId(String userId, String eventName, int createdAt, Optional<Map<String, String>> metadata, Map<String, Object> additionalProperties) {
            this.userId = userId;
            this.eventName = eventName;
            this.createdAt = createdAt;
            this.metadata = metadata;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="user_id")
        public String getUserId() {
            return this.userId;
        }

        @JsonProperty(value="event_name")
        public String getEventName() {
            return this.eventName;
        }

        @JsonProperty(value="created_at")
        public int getCreatedAt() {
            return this.createdAt;
        }

        @JsonProperty(value="metadata")
        public Optional<Map<String, String>> getMetadata() {
            return this.metadata;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof WithUserId && this.equalTo((WithUserId)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(WithUserId other) {
            return this.userId.equals(other.userId) && this.eventName.equals(other.eventName) && this.createdAt == other.createdAt && this.metadata.equals(other.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.userId, this.eventName, this.createdAt, this.metadata);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static UserIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements UserIdStage,
        EventNameStage,
        CreatedAtStage,
        _FinalStage {
            private String userId;
            private String eventName;
            private int createdAt;
            private Optional<Map<String, String>> metadata = Optional.empty();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(WithUserId other) {
                this.userId(other.getUserId());
                this.eventName(other.getEventName());
                this.createdAt(other.getCreatedAt());
                this.metadata(other.getMetadata());
                return this;
            }

            @Override
            @JsonSetter(value="user_id")
            public EventNameStage userId(@NotNull String userId) {
                this.userId = Objects.requireNonNull(userId, "userId must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="event_name")
            public CreatedAtStage eventName(@NotNull String eventName) {
                this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="created_at")
            public _FinalStage createdAt(int createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @Override
            public _FinalStage metadata(Map<String, String> metadata) {
                this.metadata = Optional.ofNullable(metadata);
                return this;
            }

            @Override
            @JsonSetter(value="metadata", nulls=Nulls.SKIP)
            public _FinalStage metadata(Optional<Map<String, String>> metadata) {
                this.metadata = metadata;
                return this;
            }

            @Override
            public WithUserId build() {
                return new WithUserId(this.userId, this.eventName, this.createdAt, this.metadata, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public WithUserId build();

            public _FinalStage metadata(Optional<Map<String, String>> var1);

            public _FinalStage metadata(Map<String, String> var1);
        }

        public static interface CreatedAtStage {
            public _FinalStage createdAt(int var1);
        }

        public static interface EventNameStage {
            public CreatedAtStage eventName(@NotNull String var1);
        }

        public static interface UserIdStage {
            public EventNameStage userId(@NotNull String var1);

            public Builder from(WithUserId var1);
        }
    }

    static final class Deserializer
    extends StdDeserializer<CreateDataEventRequest> {
        Deserializer() {
            super(CreateDataEventRequest.class);
        }

        public CreateDataEventRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return CreateDataEventRequest.of((WithId)ObjectMappers.JSON_MAPPER.convertValue(value, WithId.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return CreateDataEventRequest.of((WithUserId)ObjectMappers.JSON_MAPPER.convertValue(value, WithUserId.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    try {
                        return CreateDataEventRequest.of((WithEmail)ObjectMappers.JSON_MAPPER.convertValue(value, WithEmail.class));
                    }
                    catch (IllegalArgumentException illegalArgumentException3) {
                        throw new JsonParseException(p, "Failed to deserialize");
                    }
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(WithId var1);

        public T visit(WithUserId var1);

        public T visit(WithEmail var1);
    }
}

