/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.DropdownOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DropdownComponent {
    private final String id;
    private final List<DropdownOption> options;
    private final Optional<String> label;
    private final Optional<String> value;
    private final Optional<SaveState> saveState;
    private final Optional<Boolean> disabled;
    private final Map<String, Object> additionalProperties;

    private DropdownComponent(String id, List<DropdownOption> options, Optional<String> label, Optional<String> value, Optional<SaveState> saveState, Optional<Boolean> disabled, Map<String, Object> additionalProperties) {
        this.id = id;
        this.options = options;
        this.label = label;
        this.value = value;
        this.saveState = saveState;
        this.disabled = disabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="options")
    public List<DropdownOption> getOptions() {
        return this.options;
    }

    @JsonProperty(value="label")
    public Optional<String> getLabel() {
        return this.label;
    }

    @JsonProperty(value="value")
    public Optional<String> getValue() {
        return this.value;
    }

    @JsonProperty(value="save_state")
    public Optional<SaveState> getSaveState() {
        return this.saveState;
    }

    @JsonProperty(value="disabled")
    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DropdownComponent && this.equalTo((DropdownComponent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DropdownComponent other) {
        return this.id.equals(other.id) && this.options.equals(other.options) && this.label.equals(other.label) && this.value.equals(other.value) && this.saveState.equals(other.saveState) && this.disabled.equals(other.disabled);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.options, this.label, this.value, this.saveState, this.disabled);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class SaveState {
        public static final SaveState SAVED = new SaveState(Value.SAVED, "saved");
        public static final SaveState UNSAVED = new SaveState(Value.UNSAVED, "unsaved");
        public static final SaveState FAILED = new SaveState(Value.FAILED, "failed");
        private final Value value;
        private final String string;

        SaveState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SaveState && this.string.equals(((SaveState)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case SAVED: {
                    return visitor.visitSaved();
                }
                case UNSAVED: {
                    return visitor.visitUnsaved();
                }
                case FAILED: {
                    return visitor.visitFailed();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static SaveState valueOf(String value) {
            switch (value) {
                case "saved": {
                    return SAVED;
                }
                case "unsaved": {
                    return UNSAVED;
                }
                case "failed": {
                    return FAILED;
                }
            }
            return new SaveState(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitUnsaved();

            public T visitSaved();

            public T visitFailed();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            UNSAVED,
            SAVED,
            FAILED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<Boolean> disabled = Optional.empty();
        private Optional<SaveState> saveState = Optional.empty();
        private Optional<String> value = Optional.empty();
        private Optional<String> label = Optional.empty();
        private List<DropdownOption> options = new ArrayList<DropdownOption>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DropdownComponent other) {
            this.id(other.getId());
            this.options(other.getOptions());
            this.label(other.getLabel());
            this.value(other.getValue());
            this.saveState(other.getSaveState());
            this.disabled(other.getDisabled());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        @Override
        @JsonSetter(value="disabled", nulls=Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public _FinalStage saveState(SaveState saveState) {
            this.saveState = Optional.ofNullable(saveState);
            return this;
        }

        @Override
        @JsonSetter(value="save_state", nulls=Nulls.SKIP)
        public _FinalStage saveState(Optional<SaveState> saveState) {
            this.saveState = saveState;
            return this;
        }

        @Override
        public _FinalStage value(String value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public _FinalStage value(Optional<String> value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage label(String label) {
            this.label = Optional.ofNullable(label);
            return this;
        }

        @Override
        @JsonSetter(value="label", nulls=Nulls.SKIP)
        public _FinalStage label(Optional<String> label) {
            this.label = label;
            return this;
        }

        @Override
        public _FinalStage addAllOptions(List<DropdownOption> options) {
            this.options.addAll(options);
            return this;
        }

        @Override
        public _FinalStage addOptions(DropdownOption options) {
            this.options.add(options);
            return this;
        }

        @Override
        @JsonSetter(value="options", nulls=Nulls.SKIP)
        public _FinalStage options(List<DropdownOption> options) {
            this.options.clear();
            this.options.addAll(options);
            return this;
        }

        @Override
        public DropdownComponent build() {
            return new DropdownComponent(this.id, this.options, this.label, this.value, this.saveState, this.disabled, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DropdownComponent build();

        public _FinalStage options(List<DropdownOption> var1);

        public _FinalStage addOptions(DropdownOption var1);

        public _FinalStage addAllOptions(List<DropdownOption> var1);

        public _FinalStage label(Optional<String> var1);

        public _FinalStage label(String var1);

        public _FinalStage value(Optional<String> var1);

        public _FinalStage value(String var1);

        public _FinalStage saveState(Optional<SaveState> var1);

        public _FinalStage saveState(SaveState var1);

        public _FinalStage disabled(Optional<Boolean> var1);

        public _FinalStage disabled(Boolean var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(DropdownComponent var1);
    }
}

