/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.resources.conversations.types.Conversation;
import com.intercom.api.types.Context;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class InitializeRequest {
    private final String workspaceId;
    private final String workspaceRegion;
    private final Admin admin;
    private final Map<String, Object> cardCreationOptions;
    private final Context context;
    private final Conversation conversation;
    private final Contact contact;
    private final Map<String, Object> additionalProperties;

    private InitializeRequest(String workspaceId, String workspaceRegion, Admin admin, Map<String, Object> cardCreationOptions, Context context, Conversation conversation, Contact contact, Map<String, Object> additionalProperties) {
        this.workspaceId = workspaceId;
        this.workspaceRegion = workspaceRegion;
        this.admin = admin;
        this.cardCreationOptions = cardCreationOptions;
        this.context = context;
        this.conversation = conversation;
        this.contact = contact;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspace_region")
    public String getWorkspaceRegion() {
        return this.workspaceRegion;
    }

    @JsonProperty(value="admin")
    public Admin getAdmin() {
        return this.admin;
    }

    @JsonProperty(value="card_creation_options")
    public Map<String, Object> getCardCreationOptions() {
        return this.cardCreationOptions;
    }

    @JsonProperty(value="context")
    public Context getContext() {
        return this.context;
    }

    @JsonProperty(value="conversation")
    public Conversation getConversation() {
        return this.conversation;
    }

    @JsonProperty(value="contact")
    public Contact getContact() {
        return this.contact;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof InitializeRequest && this.equalTo((InitializeRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(InitializeRequest other) {
        return this.workspaceId.equals(other.workspaceId) && this.workspaceRegion.equals(other.workspaceRegion) && this.admin.equals(other.admin) && this.cardCreationOptions.equals(other.cardCreationOptions) && this.context.equals(other.context) && this.conversation.equals(other.conversation) && this.contact.equals(other.contact);
    }

    public int hashCode() {
        return Objects.hash(this.workspaceId, this.workspaceRegion, this.admin, this.cardCreationOptions, this.context, this.conversation, this.contact);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WorkspaceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WorkspaceIdStage,
    WorkspaceRegionStage,
    AdminStage,
    ContextStage,
    ConversationStage,
    ContactStage,
    _FinalStage {
        private String workspaceId;
        private String workspaceRegion;
        private Admin admin;
        private Context context;
        private Conversation conversation;
        private Contact contact;
        private Map<String, Object> cardCreationOptions = new LinkedHashMap<String, Object>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(InitializeRequest other) {
            this.workspaceId(other.getWorkspaceId());
            this.workspaceRegion(other.getWorkspaceRegion());
            this.admin(other.getAdmin());
            this.cardCreationOptions(other.getCardCreationOptions());
            this.context(other.getContext());
            this.conversation(other.getConversation());
            this.contact(other.getContact());
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public WorkspaceRegionStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_region")
        public AdminStage workspaceRegion(@NotNull String workspaceRegion) {
            this.workspaceRegion = Objects.requireNonNull(workspaceRegion, "workspaceRegion must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="admin")
        public ContextStage admin(@NotNull Admin admin) {
            this.admin = Objects.requireNonNull(admin, "admin must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="context")
        public ConversationStage context(@NotNull Context context) {
            this.context = Objects.requireNonNull(context, "context must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="conversation")
        public ContactStage conversation(@NotNull Conversation conversation) {
            this.conversation = Objects.requireNonNull(conversation, "conversation must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contact")
        public _FinalStage contact(@NotNull Contact contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @Override
        public _FinalStage cardCreationOptions(String key, Object value) {
            this.cardCreationOptions.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllCardCreationOptions(Map<String, Object> cardCreationOptions) {
            this.cardCreationOptions.putAll(cardCreationOptions);
            return this;
        }

        @Override
        @JsonSetter(value="card_creation_options", nulls=Nulls.SKIP)
        public _FinalStage cardCreationOptions(Map<String, Object> cardCreationOptions) {
            this.cardCreationOptions.clear();
            this.cardCreationOptions.putAll(cardCreationOptions);
            return this;
        }

        @Override
        public InitializeRequest build() {
            return new InitializeRequest(this.workspaceId, this.workspaceRegion, this.admin, this.cardCreationOptions, this.context, this.conversation, this.contact, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public InitializeRequest build();

        public _FinalStage cardCreationOptions(Map<String, Object> var1);

        public _FinalStage putAllCardCreationOptions(Map<String, Object> var1);

        public _FinalStage cardCreationOptions(String var1, Object var2);
    }

    public static interface ContactStage {
        public _FinalStage contact(@NotNull Contact var1);
    }

    public static interface ConversationStage {
        public ContactStage conversation(@NotNull Conversation var1);
    }

    public static interface ContextStage {
        public ConversationStage context(@NotNull Context var1);
    }

    public static interface AdminStage {
        public ContextStage admin(@NotNull Admin var1);
    }

    public static interface WorkspaceRegionStage {
        public AdminStage workspaceRegion(@NotNull String var1);
    }

    public static interface WorkspaceIdStage {
        public WorkspaceRegionStage workspaceId(@NotNull String var1);

        public Builder from(InitializeRequest var1);
    }
}

