/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.types.CanvasObject;
import com.intercom.api.types.Context;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class LiveCanvasRequest {
    private final String workspaceId;
    private final String workspaceRegion;
    private final CanvasObject canvas;
    private final Context context;
    private final Contact contact;
    private final Map<String, Object> additionalProperties;

    private LiveCanvasRequest(String workspaceId, String workspaceRegion, CanvasObject canvas, Context context, Contact contact, Map<String, Object> additionalProperties) {
        this.workspaceId = workspaceId;
        this.workspaceRegion = workspaceRegion;
        this.canvas = canvas;
        this.context = context;
        this.contact = contact;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="workspace_id")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspace_region")
    public String getWorkspaceRegion() {
        return this.workspaceRegion;
    }

    @JsonProperty(value="canvas")
    public CanvasObject getCanvas() {
        return this.canvas;
    }

    @JsonProperty(value="context")
    public Context getContext() {
        return this.context;
    }

    @JsonProperty(value="contact")
    public Contact getContact() {
        return this.contact;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof LiveCanvasRequest && this.equalTo((LiveCanvasRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LiveCanvasRequest other) {
        return this.workspaceId.equals(other.workspaceId) && this.workspaceRegion.equals(other.workspaceRegion) && this.canvas.equals(other.canvas) && this.context.equals(other.context) && this.contact.equals(other.contact);
    }

    public int hashCode() {
        return Objects.hash(this.workspaceId, this.workspaceRegion, this.canvas, this.context, this.contact);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static WorkspaceIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements WorkspaceIdStage,
    WorkspaceRegionStage,
    CanvasStage,
    ContextStage,
    ContactStage,
    _FinalStage {
        private String workspaceId;
        private String workspaceRegion;
        private CanvasObject canvas;
        private Context context;
        private Contact contact;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(LiveCanvasRequest other) {
            this.workspaceId(other.getWorkspaceId());
            this.workspaceRegion(other.getWorkspaceRegion());
            this.canvas(other.getCanvas());
            this.context(other.getContext());
            this.contact(other.getContact());
            return this;
        }

        @Override
        @JsonSetter(value="workspace_id")
        public WorkspaceRegionStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="workspace_region")
        public CanvasStage workspaceRegion(@NotNull String workspaceRegion) {
            this.workspaceRegion = Objects.requireNonNull(workspaceRegion, "workspaceRegion must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="canvas")
        public ContextStage canvas(@NotNull CanvasObject canvas) {
            this.canvas = Objects.requireNonNull(canvas, "canvas must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="context")
        public ContactStage context(@NotNull Context context) {
            this.context = Objects.requireNonNull(context, "context must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="contact")
        public _FinalStage contact(@NotNull Contact contact) {
            this.contact = Objects.requireNonNull(contact, "contact must not be null");
            return this;
        }

        @Override
        public LiveCanvasRequest build() {
            return new LiveCanvasRequest(this.workspaceId, this.workspaceRegion, this.canvas, this.context, this.contact, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public LiveCanvasRequest build();
    }

    public static interface ContactStage {
        public _FinalStage contact(@NotNull Contact var1);
    }

    public static interface ContextStage {
        public ContactStage context(@NotNull Context var1);
    }

    public static interface CanvasStage {
        public ContextStage canvas(@NotNull CanvasObject var1);
    }

    public static interface WorkspaceRegionStage {
        public CanvasStage workspaceRegion(@NotNull String var1);
    }

    public static interface WorkspaceIdStage {
        public WorkspaceRegionStage workspaceId(@NotNull String var1);

        public Builder from(LiveCanvasRequest var1);
    }
}

