/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.MultipleOrSingleFilterSearchRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class MultipleFilterSearchRequest {
    private final Optional<Operator> operator;
    private final Optional<List<MultipleOrSingleFilterSearchRequest>> value;
    private final Map<String, Object> additionalProperties;

    private MultipleFilterSearchRequest(Optional<Operator> operator, Optional<List<MultipleOrSingleFilterSearchRequest>> value, Map<String, Object> additionalProperties) {
        this.operator = operator;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="operator")
    public Optional<Operator> getOperator() {
        return this.operator;
    }

    @JsonProperty(value="value")
    public Optional<List<MultipleOrSingleFilterSearchRequest>> getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof MultipleFilterSearchRequest && this.equalTo((MultipleFilterSearchRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(MultipleFilterSearchRequest other) {
        return this.operator.equals(other.operator) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Operator {
        public static final Operator AND = new Operator(Value.AND, "AND");
        public static final Operator OR = new Operator(Value.OR, "OR");
        private final Value value;
        private final String string;

        Operator(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof Operator && this.string.equals(((Operator)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case AND: {
                    return visitor.visitAnd();
                }
                case OR: {
                    return visitor.visitOr();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static Operator valueOf(String value) {
            switch (value) {
                case "AND": {
                    return AND;
                }
                case "OR": {
                    return OR;
                }
            }
            return new Operator(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitAnd();

            public T visitOr();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            AND,
            OR,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Operator> operator = Optional.empty();
        private Optional<List<MultipleOrSingleFilterSearchRequest>> value = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(MultipleFilterSearchRequest other) {
            this.operator(other.getOperator());
            this.value(other.getValue());
            return this;
        }

        @JsonSetter(value="operator", nulls=Nulls.SKIP)
        public Builder operator(Optional<Operator> operator) {
            this.operator = operator;
            return this;
        }

        public Builder operator(Operator operator) {
            this.operator = Optional.ofNullable(operator);
            return this;
        }

        @JsonSetter(value="value", nulls=Nulls.SKIP)
        public Builder value(Optional<List<MultipleOrSingleFilterSearchRequest>> value) {
            this.value = value;
            return this;
        }

        public Builder value(List<MultipleOrSingleFilterSearchRequest> value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        public MultipleFilterSearchRequest build() {
            return new MultipleFilterSearchRequest(this.operator, this.value, this.additionalProperties);
        }
    }
}

