/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.conversations.types.Conversation;
import com.intercom.api.types.CursorPages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PaginatedConversationResponse {
    private final List<Conversation> conversations;
    private final int totalCount;
    private final Optional<CursorPages> pages;
    private final Map<String, Object> additionalProperties;

    private PaginatedConversationResponse(List<Conversation> conversations, int totalCount, Optional<CursorPages> pages, Map<String, Object> additionalProperties) {
        this.conversations = conversations;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "conversation.list";
    }

    @JsonProperty(value="conversations")
    public List<Conversation> getConversations() {
        return this.conversations;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PaginatedConversationResponse && this.equalTo((PaginatedConversationResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaginatedConversationResponse other) {
        return this.conversations.equals(other.conversations) && this.totalCount == other.totalCount && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.conversations, this.totalCount, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private Optional<CursorPages> pages = Optional.empty();
        private List<Conversation> conversations = new ArrayList<Conversation>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PaginatedConversationResponse other) {
            this.conversations(other.getConversations());
            this.totalCount(other.getTotalCount());
            this.pages(other.getPages());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @Override
        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public _FinalStage pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        @Override
        public _FinalStage addAllConversations(List<Conversation> conversations) {
            this.conversations.addAll(conversations);
            return this;
        }

        @Override
        public _FinalStage addConversations(Conversation conversations) {
            this.conversations.add(conversations);
            return this;
        }

        @Override
        @JsonSetter(value="conversations", nulls=Nulls.SKIP)
        public _FinalStage conversations(List<Conversation> conversations) {
            this.conversations.clear();
            this.conversations.addAll(conversations);
            return this;
        }

        @Override
        public PaginatedConversationResponse build() {
            return new PaginatedConversationResponse(this.conversations, this.totalCount, this.pages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PaginatedConversationResponse build();

        public _FinalStage conversations(List<Conversation> var1);

        public _FinalStage addConversations(Conversation var1);

        public _FinalStage addAllConversations(List<Conversation> var1);

        public _FinalStage pages(Optional<CursorPages> var1);

        public _FinalStage pages(CursorPages var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(PaginatedConversationResponse var1);
    }
}

