/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.segments.types.Segment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SegmentList {
    private final List<Segment> segments;
    private final Optional<Map<String, Object>> pages;
    private final Map<String, Object> additionalProperties;

    private SegmentList(List<Segment> segments, Optional<Map<String, Object>> pages, Map<String, Object> additionalProperties) {
        this.segments = segments;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "segment.list";
    }

    @JsonProperty(value="segments")
    public List<Segment> getSegments() {
        return this.segments;
    }

    @JsonProperty(value="pages")
    public Optional<Map<String, Object>> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SegmentList && this.equalTo((SegmentList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SegmentList other) {
        return this.segments.equals(other.segments) && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.segments, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<Segment> segments = new ArrayList<Segment>();
        private Optional<Map<String, Object>> pages = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(SegmentList other) {
            this.segments(other.getSegments());
            this.pages(other.getPages());
            return this;
        }

        @JsonSetter(value="segments", nulls=Nulls.SKIP)
        public Builder segments(List<Segment> segments) {
            this.segments.clear();
            this.segments.addAll(segments);
            return this;
        }

        public Builder addSegments(Segment segments) {
            this.segments.add(segments);
            return this;
        }

        public Builder addAllSegments(List<Segment> segments) {
            this.segments.addAll(segments);
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<Map<String, Object>> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(Map<String, Object> pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        public SegmentList build() {
            return new SegmentList(this.segments, this.pages, this.additionalProperties);
        }
    }
}

