/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.PartAttachment;
import com.intercom.api.types.TicketPartAuthor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketReply {
    private final String id;
    private final PartType partType;
    private final Optional<String> body;
    private final int createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<TicketPartAuthor> author;
    private final Optional<List<PartAttachment>> attachments;
    private final Optional<Boolean> redacted;
    private final Map<String, Object> additionalProperties;

    private TicketReply(String id, PartType partType, Optional<String> body, int createdAt, Optional<Integer> updatedAt, Optional<TicketPartAuthor> author, Optional<List<PartAttachment>> attachments, Optional<Boolean> redacted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.author = author;
        this.attachments = attachments;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "ticket_part";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="part_type")
    public PartType getPartType() {
        return this.partType;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="author")
    public Optional<TicketPartAuthor> getAuthor() {
        return this.author;
    }

    @JsonProperty(value="attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="redacted")
    public Optional<Boolean> getRedacted() {
        return this.redacted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketReply && this.equalTo((TicketReply)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketReply other) {
        return this.id.equals(other.id) && this.partType.equals(other.partType) && this.body.equals(other.body) && this.createdAt == other.createdAt && this.updatedAt.equals(other.updatedAt) && this.author.equals(other.author) && this.attachments.equals(other.attachments) && this.redacted.equals(other.redacted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.author, this.attachments, this.redacted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class PartType {
        public static final PartType NOTE = new PartType(Value.NOTE, "note");
        public static final PartType QUICK_REPLY = new PartType(Value.QUICK_REPLY, "quick_reply");
        public static final PartType COMMENT = new PartType(Value.COMMENT, "comment");
        private final Value value;
        private final String string;

        PartType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PartType && this.string.equals(((PartType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case NOTE: {
                    return visitor.visitNote();
                }
                case QUICK_REPLY: {
                    return visitor.visitQuickReply();
                }
                case COMMENT: {
                    return visitor.visitComment();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static PartType valueOf(String value) {
            switch (value) {
                case "note": {
                    return NOTE;
                }
                case "quick_reply": {
                    return QUICK_REPLY;
                }
                case "comment": {
                    return COMMENT;
                }
            }
            return new PartType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitNote();

            public T visitComment();

            public T visitQuickReply();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            NOTE,
            COMMENT,
            QUICK_REPLY,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    PartTypeStage,
    CreatedAtStage,
    _FinalStage {
        private String id;
        private PartType partType;
        private int createdAt;
        private Optional<Boolean> redacted = Optional.empty();
        private Optional<List<PartAttachment>> attachments = Optional.empty();
        private Optional<TicketPartAuthor> author = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TicketReply other) {
            this.id(other.getId());
            this.partType(other.getPartType());
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.author(other.getAuthor());
            this.attachments(other.getAttachments());
            this.redacted(other.getRedacted());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PartTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="part_type")
        public CreatedAtStage partType(@NotNull PartType partType) {
            this.partType = Objects.requireNonNull(partType, "partType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage redacted(Boolean redacted) {
            this.redacted = Optional.ofNullable(redacted);
            return this;
        }

        @Override
        @JsonSetter(value="redacted", nulls=Nulls.SKIP)
        public _FinalStage redacted(Optional<Boolean> redacted) {
            this.redacted = redacted;
            return this;
        }

        @Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @Override
        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        @Override
        public _FinalStage author(TicketPartAuthor author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        @Override
        @JsonSetter(value="author", nulls=Nulls.SKIP)
        public _FinalStage author(Optional<TicketPartAuthor> author) {
            this.author = author;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public TicketReply build() {
            return new TicketReply(this.id, this.partType, this.body, this.createdAt, this.updatedAt, this.author, this.attachments, this.redacted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TicketReply build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);

        public _FinalStage author(Optional<TicketPartAuthor> var1);

        public _FinalStage author(TicketPartAuthor var1);

        public _FinalStage attachments(Optional<List<PartAttachment>> var1);

        public _FinalStage attachments(List<PartAttachment> var1);

        public _FinalStage redacted(Optional<Boolean> var1);

        public _FinalStage redacted(Boolean var1);
    }

    public static interface CreatedAtStage {
        public _FinalStage createdAt(int var1);
    }

    public static interface PartTypeStage {
        public CreatedAtStage partType(@NotNull PartType var1);
    }

    public static interface IdStage {
        public PartTypeStage id(@NotNull String var1);

        public Builder from(TicketReply var1);
    }
}

