/*
 * Decompiled with CFR 0.152.
 */
package io.klib.mvn.deploy.java;

import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class App {
    public static void main(String[] args) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss");
        String timestamp = LocalDateTime.now().format(formatter);
        System.out.println("Hello Maven Central deployment " + timestamp);
        System.out.println("Implementation-Version: " + App.readImplementationVersion());
    }

    private static String readImplementationVersion() {
        Object rv;
        block7: {
            rv = "This class is not inside a JAR file.";
            try {
                String classPath = App.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                if (!classPath.endsWith(".jar")) break block7;
                try (JarFile jarFile = new JarFile(classPath);){
                    Manifest manifest = jarFile.getManifest();
                    Attributes mainAttributes = manifest.getMainAttributes();
                    String version = mainAttributes.getValue("Implementation-Version");
                    rv = version != null ? "Implementation-Version: " + version : "Implementation-Version not found in the manifest.";
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rv;
    }
}

